/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.io.File;
import java.io.FilenameFilter;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;

public class LogSerializer {
    protected FilenameFilter logFilenameFilter = null;
    protected SergeSettings settings = null;

    public LogSerializer(SergeSettings settings) {
        this.settings = settings;
        this.logFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String fileName) {
                return fileName.endsWith(".log");
            }
        };
        if (settings.isDeleteLogs()) {
            this.deletePreviousLogs();
        }
    }

    protected void deletePreviousLogs() {
        String outputFolderPath = String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator");
        File folder = new File(outputFolderPath);
        if (folder.exists()) {
            File[] files;
            File[] fileArray = files = folder.listFiles(this.logFilenameFilter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
    }
}

