/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.sidiff.editrule.generator.types.OperationType;

public class InverseModuleMapper {
    private Map<Map<Module, Module>, Set<Map<Parameter, Parameter>>> inverseModulePairMap = new HashMap<Map<Module, Module>, Set<Map<Parameter, Parameter>>>();

    private void addInverseModulePair(Module m1, Module m2) {
        HashMap<Module, Module> modulePair = new HashMap<Module, Module>();
        modulePair.put(m1, m2);
        HashMap<Parameter, Parameter> mappedParameters = new HashMap<Parameter, Parameter>();
        HashSet<HashMap<Parameter, Parameter>> mappedParameterSet = new HashSet<HashMap<Parameter, Parameter>>();
        for (Parameter p1 : m1.getUnit("mainUnit").getParameters()) {
            String p1Name = p1.getName();
            Parameter correspondingParameter = null;
            if (p1Name.matches("New[0-9]*")) {
                String number = p1Name.replace("New", "");
                correspondingParameter = m2.getUnit("mainUnit").getParameter("ToBeDeleted" + number);
            } else {
                correspondingParameter = p1Name.startsWith("NewTarget") ? m2.getUnit("mainUnit").getParameter("OldTarget") : m2.getUnit("mainUnit").getParameter(p1.getName());
            }
            if (correspondingParameter == null) continue;
            mappedParameters.put(p1, correspondingParameter);
            mappedParameterSet.add(mappedParameters);
        }
        this.inverseModulePairMap.put(modulePair, mappedParameterSet);
    }

    public Set<Map.Entry<Map<Module, Module>, Set<Map<Parameter, Parameter>>>> getAllInverseModulePairs() {
        return this.inverseModulePairMap.entrySet();
    }

    public void findAndMapInversePairs(Map<OperationType, Set<Module>> allModules) {
        Set<Module> creates = allModules.get(OperationType.CREATE);
        Set<Module> deletes = allModules.get(OperationType.DELETE);
        Set<Map<Module, Module>> set1 = this.getInverseModulesByName(creates, deletes, OperationType.CREATE);
        for (Map<Module, Module> pair : set1) {
            Module a = pair.entrySet().iterator().next().getKey();
            Module b = pair.entrySet().iterator().next().getValue();
            this.addInverseModulePair(a, b);
        }
        Set<Module> adds = allModules.get(OperationType.ADD);
        Set<Module> removes = allModules.get(OperationType.REMOVE);
        Set<Map<Module, Module>> set2 = this.getInverseModulesByName(adds, removes, OperationType.ADD);
        for (Map<Module, Module> pair : set2) {
            Module a = pair.entrySet().iterator().next().getKey();
            Module b = pair.entrySet().iterator().next().getValue();
            this.addInverseModulePair(a, b);
        }
        Set<Module> setAttributes = allModules.get(OperationType.SET_ATTRIBUTE);
        Set<Module> unsetAttributes = allModules.get(OperationType.UNSET_ATTRIBUTE);
        Set<Map<Module, Module>> set3 = this.getInverseModulesByName(setAttributes, unsetAttributes, OperationType.SET_ATTRIBUTE);
        for (Map<Module, Module> pair : set3) {
            Module a = pair.entrySet().iterator().next().getKey();
            Module b = pair.entrySet().iterator().next().getValue();
            this.addInverseModulePair(a, b);
        }
        Set<Module> setReferences = allModules.get(OperationType.SET_REFERENCE);
        Set<Module> unsetReferences = allModules.get(OperationType.UNSET_REFERENCE);
        Set<Map<Module, Module>> set4 = this.getInverseModulesByName(setReferences, unsetReferences, OperationType.SET_REFERENCE);
        for (Map<Module, Module> pair : set4) {
            Module a = pair.entrySet().iterator().next().getKey();
            Module b = pair.entrySet().iterator().next().getValue();
            this.addInverseModulePair(a, b);
        }
    }

    private Set<Map<Module, Module>> getInverseModulesByName(Set<Module> sm1, Set<Module> sm2, OperationType orginalOPType) {
        HashSet<Map<Module, Module>> pairs = new HashSet<Map<Module, Module>>();
        switch (orginalOPType) {
            case CREATE: {
                HashMap<Module, Module> pair;
                String expectedName2;
                String name1;
                block6: for (Module m1 : sm1) {
                    for (Module m2 : sm2) {
                        name1 = m1.getName();
                        expectedName2 = name1.replaceFirst("CREATE_", "DELETE_");
                        if (!m2.getName().equals(expectedName2)) continue;
                        pair = new HashMap<Module, Module>();
                        pair.put(m1, m2);
                        pairs.add(pair);
                        continue block6;
                    }
                }
            }
            case ADD: {
                HashMap<Module, Module> pair;
                String expectedName2;
                String name1;
                block8: for (Module m1 : sm1) {
                    for (Module m2 : sm2) {
                        name1 = m1.getName();
                        expectedName2 = name1.replaceFirst("ADD_", "REMOVE_");
                        if (!m2.getName().equals(expectedName2)) continue;
                        pair = new HashMap();
                        pair.put(m1, m2);
                        pairs.add(pair);
                        continue block8;
                    }
                }
            }
            case SET_ATTRIBUTE: {
                HashMap<Module, Module> pair;
                String expectedName2;
                String name1;
                block10: for (Module m1 : sm1) {
                    for (Module m2 : sm2) {
                        name1 = m1.getName();
                        expectedName2 = name1.replaceFirst("SET_ATTRIBUTE_", "UNSET_ATTRIBUTE_");
                        if (!m2.getName().equals(expectedName2)) continue;
                        pair = new HashMap();
                        pair.put(m1, m2);
                        pairs.add(pair);
                        continue block10;
                    }
                }
            }
            case SET_REFERENCE: {
                HashMap<Module, Module> pair;
                String expectedName2;
                String name1;
                block12: for (Module m1 : sm1) {
                    for (Module m2 : sm2) {
                        name1 = m1.getName();
                        expectedName2 = name1.replaceFirst("SET_REFERENCE_", "UNSET_REFERENCE_");
                        if (!m2.getName().equals(expectedName2)) continue;
                        pair = new HashMap();
                        pair.put(m1, m2);
                        pairs.add(pair);
                        continue block12;
                    }
                }
                break;
            }
        }
        return pairs;
    }
}

