/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.sidiff.editrule.generator.serge.core.InverseModuleMapper;
import org.sidiff.editrule.generator.serge.core.LogSerializer;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;

public class InverseModuleMapSerializer
extends LogSerializer {
    public InverseModuleMapSerializer(SergeSettings settings) {
        super(settings);
    }

    public void serialize(InverseModuleMapper inverseModuleMapper) {
        String content = "";
        for (Map.Entry<Map<Module, Module>, Set<Map<Parameter, Parameter>>> pair : inverseModuleMapper.getAllInverseModulePairs()) {
            Map<Module, Module> modulePair = pair.getKey();
            Set<Map<Parameter, Parameter>> correspondingParameterPairs = pair.getValue();
            Module m1 = modulePair.entrySet().iterator().next().getKey();
            Module m2 = modulePair.get(m1);
            content = String.valueOf(content) + "\n" + m1.getName() + " <--> " + m2.getName();
            for (Map<Parameter, Parameter> parameterPair : correspondingParameterPairs) {
                Parameter p1 = parameterPair.entrySet().iterator().next().getKey();
                Parameter p2 = parameterPair.get(p1);
                content = String.valueOf(content) + "| " + p1.getName() + " <--> " + p2.getName();
            }
        }
        String outputFilePath = String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator") + "_InverseModuleMap.log";
        File file = new File(outputFilePath);
        FileOutputStream fop = null;
        try {
            fop = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = content.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

