/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.emf.extensions.impl.ContainmentCycle;
import org.sidiff.common.emf.extensions.impl.ContainmentCyclePathStep;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.emf.extensions.impl.EcoreHelper;
import org.sidiff.common.emf.extensions.impl.Mask;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.exceptions.ModuleForInverseCreationRequiredException;
import org.sidiff.editrule.generator.serge.filter.ElementFilter;
import org.sidiff.editrule.generator.serge.generators.actions.AddGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.ChangeLiteralGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.ChangeReferenceGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.CreateGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.DeleteGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.MoveDownGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.MoveGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.MoveMaskedElementGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.MoveReferenceCombinationGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.MoveUpGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.RemoveGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.SetAttributeGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.SetReferenceGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.UnsetAttributeGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.UnsetReferenceGenerator;
import org.sidiff.editrule.generator.serge.generators.actions.VariantGenerator;
import org.sidiff.editrule.generator.types.OperationType;
import org.silift.common.util.access.EMFMetaAccessEx;

public class GenerationActionDelegator {
    private static GenerationActionDelegator GAD = null;
    private static Configuration c = Configuration.getInstance();
    private static EClassifierInfoManagement ECM = EClassifierInfoManagement.getInstance();
    private static ElementFilter FILTER = ElementFilter.getInstance();

    public static GenerationActionDelegator getInstance() {
        if (GAD == null) {
            GAD = new GenerationActionDelegator();
        }
        return GAD;
    }

    public Set<Module> generate_CREATE(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_CREATES) {
            Module resultModule;
            CreateGenerator generator;
            boolean isOWL = eClassifier.getEPackage().getName().equals("owl");
            if (isOWL) {
                EClass ontology = null;
                for (EClassifier owlClassifier : eClassifier.getEPackage().getEClassifiers()) {
                    if (!owlClassifier.getName().equals("Ontology")) continue;
                    ontology = (EClass)owlClassifier;
                    break;
                }
                EReference ontology_container = null;
                for (EReference ontology_reference : ontology.getEReferences()) {
                    if (!ontology_reference.getName().equals("container")) continue;
                    ontology_container = ontology_reference;
                }
                generator = new CreateGenerator(ontology_container, (EClassifier)ontology, ECM.getEClassifierInfo(eClassifier));
                resultModule = generator.generate();
                modules.add(resultModule);
            }
            if (FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.CREATE).booleanValue()) {
                EClassifierInfo eInf = ECM.getEClassifierInfo(eClassifier);
                if (!GenerationActionDelegator.c.PROFILE_APPLICATION_IN_USE.booleanValue() || GenerationActionDelegator.c.PROFILE_APPLICATION_IN_USE.booleanValue() && !eInf.isStereotype()) {
                    HashMap optionalParents = ECM.getAllOptionalParentContext(eClassifier, Boolean.valueOf(GenerationActionDelegator.c.REDUCETOSUPERTYPE_CREATEDELETE));
                    if (optionalParents.isEmpty() && !(eClassifier instanceof EEnum) && !isOWL) {
                        generator = new CreateGenerator(null, null, eInf);
                        resultModule = generator.generate();
                        modules.add(resultModule);
                    } else {
                        for (Map.Entry pcEntry : optionalParents.entrySet()) {
                            List contexts = (List)pcEntry.getValue();
                            EReference eRef = (EReference)pcEntry.getKey();
                            for (EClassifier context : contexts) {
                                if (!FILTER.isAllowedAsDangling(context, OperationType.CREATE, GenerationActionDelegator.c.REDUCETOSUPERTYPE_CREATEDELETE).booleanValue()) continue;
                                CreateGenerator generator2 = new CreateGenerator(eRef, context, eInf);
                                Module resultModule2 = generator2.generate();
                                modules.add(resultModule2);
                            }
                        }
                    }
                } else {
                    CreateGenerator generator3 = new CreateGenerator(null, null, eInf);
                    Module resultModule3 = generator3.generate();
                    modules.add(resultModule3);
                }
            }
        }
        return modules;
    }

    public Set<Module> generate_DELETE(Set<Module> createModulesSet) throws ModuleForInverseCreationRequiredException, OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_DELETES) {
            if (!GenerationActionDelegator.c.CREATE_CREATES) {
                throw new ModuleForInverseCreationRequiredException(OperationType.DELETE);
            }
            for (Module createModule : createModulesSet) {
                DeleteGenerator generator = new DeleteGenerator(createModule);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> generate_MOVE(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        boolean isOWL = eClassifier.getEPackage().getName().equals("owl");
        if (isOWL) {
            EClass ontology = null;
            for (EClassifier owlClassifier : eClassifier.getEPackage().getEClassifiers()) {
                if (!owlClassifier.getName().equals("Ontology")) continue;
                ontology = (EClass)owlClassifier;
                break;
            }
            EReference ontology_container = null;
            for (EReference ontology_reference : ontology.getEReferences()) {
                if (!ontology_reference.getName().equals("container")) continue;
                ontology_container = ontology_reference;
            }
            MoveGenerator generator = new MoveGenerator(eClassifier, ontology_container, (EClassifier)ontology, (EClassifier)ontology);
            modules.add(generator.generate());
        }
        if (GenerationActionDelegator.c.CREATE_MOVES && FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.MOVE).booleanValue()) {
            ArrayList eClassifierMasks = new ArrayList();
            eClassifierMasks.addAll(ECM.getEClassifierInfo(eClassifier).getMasks());
            HashMap<EReference, List<EClass>> allAllowedParents = FILTER.getAllAllowedParentContexts(eClassifier, GenerationActionDelegator.c.REDUCETOSUPERTYPE_MOVE, OperationType.MOVE);
            for (Map.Entry<EReference, List<EClass>> entry : allAllowedParents.entrySet()) {
                EReference oldERefToOldParent = entry.getKey();
                List<EClass> contexts_eRefA = entry.getValue();
                for (EClass oldParent : contexts_eRefA) {
                    for (EClass newParent : contexts_eRefA) {
                        MoveGenerator generator = new MoveGenerator(eClassifier, oldERefToOldParent, (EClassifier)oldParent, (EClassifier)newParent);
                        modules.add(generator.generate());
                        for (Mask mask : eClassifierMasks) {
                            MoveMaskedElementGenerator generatorForMasks = new MoveMaskedElementGenerator(mask, oldERefToOldParent, (EClassifier)oldParent, (EClassifier)newParent, oldERefToOldParent, OperationType.MOVE);
                            modules.add(generatorForMasks.generate());
                        }
                    }
                }
            }
        }
        return modules;
    }

    public Set<Module> generate_MOVE_UP(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        EClassifierInfo eInfo = ECM.getEClassifierInfo(eClassifier);
        if (GenerationActionDelegator.c.CREATE_MOVE_UPS && FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.MOVE_UP).booleanValue()) {
            Set ccSet = eInfo.getContainmentCycles();
            for (ContainmentCycle cc : ccSet) {
                if (cc.isInnerCircle().booleanValue()) continue;
                ContainmentCyclePathStep step = cc.getBackwardPointingStep();
                EReference eRef = step.getTargetingReference();
                EClassifier parent = (EClassifier)eRef.eContainer();
                if (!GenerationActionDelegator.c.CREATE_MOVE_UPS || !FILTER.isAllowedAsDangling(parent, OperationType.MOVE_UP, GenerationActionDelegator.c.REDUCETOSUPERTYPE_MOVE_UP).booleanValue()) continue;
                MoveUpGenerator generator = new MoveUpGenerator(eClassifier, cc);
                modules.add(generator.generate());
            }
        }
        return modules;
    }

    public Set<Module> generate_MOVE_DOWN(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        EClassifierInfo eInfo = ECM.getEClassifierInfo(eClassifier);
        if (GenerationActionDelegator.c.CREATE_MOVE_DOWNS && FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.MOVE_DOWN).booleanValue()) {
            Set ccSet = eInfo.getContainmentCycles();
            for (ContainmentCycle cc : ccSet) {
                if (cc.isInnerCircle().booleanValue()) continue;
                ContainmentCyclePathStep step = cc.getBackwardPointingStep();
                EReference eRef = step.getTargetingReference();
                EClassifier parent = (EClassifier)eRef.eContainer();
                if (!GenerationActionDelegator.c.CREATE_MOVE_DOWNS || !FILTER.isAllowedAsDangling(parent, OperationType.MOVE_DOWN, GenerationActionDelegator.c.REDUCETOSUPERTYPE_MOVE_DOWN).booleanValue()) continue;
                MoveDownGenerator generator = new MoveDownGenerator(eClassifier, cc);
                modules.add(generator.generate());
            }
        }
        return modules;
    }

    public Set<Module> generate_MOVE_REFERENCE_COMBINATION(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_MOVE_REFERENCE_COMBINATIONS && FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.MOVE_REFERENCE_COMBINATION).booleanValue()) {
            ArrayList eClassifierMasks = new ArrayList();
            eClassifierMasks.addAll(ECM.getEClassifierInfo(eClassifier).getMasks());
            HashMap<EReference, List<EClass>> allAllowedParents = FILTER.getAllAllowedParentContexts(eClassifier, GenerationActionDelegator.c.REDUCETOSUPERTYPE_MOVE_REFERENCE_COMBINATION, OperationType.MOVE_REFERENCE_COMBINATION);
            for (Map.Entry<EReference, List<EClass>> entry : allAllowedParents.entrySet()) {
                EReference oldERefToOldParent = entry.getKey();
                List<EClass> contexts_eRefA = entry.getValue();
                for (EClass oldParent : contexts_eRefA) {
                    ArrayList<EReference> allOtherEReferences = new ArrayList<EReference>();
                    allOtherEReferences.addAll(allAllowedParents.keySet());
                    allOtherEReferences.remove(oldParent);
                    for (EReference newERefToNewParent : allOtherEReferences) {
                        for (EClass newParent : allAllowedParents.get(newERefToNewParent)) {
                            MoveReferenceCombinationGenerator generator = new MoveReferenceCombinationGenerator(eClassifier, oldERefToOldParent, (EClassifier)oldParent, (EClassifier)newParent, newERefToNewParent);
                            modules.add(generator.generate());
                            for (Mask mask : eClassifierMasks) {
                                MoveMaskedElementGenerator generatorForMasks = new MoveMaskedElementGenerator(mask, oldERefToOldParent, (EClassifier)oldParent, (EClassifier)newParent, newERefToNewParent, OperationType.MOVE_REFERENCE_COMBINATION);
                                modules.add(generatorForMasks.generate());
                            }
                        }
                    }
                }
            }
        }
        return modules;
    }

    public Set<Module> generate_ADD(EClass contextClass) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_ADDS) {
            if (!FILTER.isAllowedAsModuleBasis((EClassifier)contextClass, OperationType.ADD).booleanValue()) {
                return modules;
            }
            for (EReference eRef : contextClass.getEAllReferences()) {
                if (EMFMetaAccessEx.isUnconsideredStructualFeature((EStructuralFeature)eRef) || eRef.isContainment() || eRef.getEOpposite() != null && eRef.getEOpposite().isContainment() || !eRef.isMany() || eRef.getLowerBound() == eRef.getUpperBound() || !FILTER.isAllowedAsDangling((EClassifier)eRef.getEReferenceType(), OperationType.ADD, GenerationActionDelegator.c.REDUCETOSUPERTYPE_ADDREMOVE).booleanValue() || GenerationActionDelegator.c.REDUCETOSUPERTYPE_ADDREMOVE && EcoreHelper.isInheritedReference((EReference)eRef, (EClassifier)contextClass)) continue;
                AddGenerator generator = new AddGenerator(eRef, contextClass);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> generate_REMOVE(Set<Module> addModules) throws ModuleForInverseCreationRequiredException, OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_REMOVES) {
            if (!GenerationActionDelegator.c.CREATE_ADDS) {
                throw new ModuleForInverseCreationRequiredException(OperationType.REMOVE);
            }
            for (Module addModule : addModules) {
                RemoveGenerator generator = new RemoveGenerator(addModule);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> generate_SET_ATTRIBUTE(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_SET_ATTRIBUTES) {
            if (!FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.SET_ATTRIBUTE).booleanValue()) {
                return modules;
            }
            EClass eClass = (EClass)eClassifier;
            EList easToConsider = new ArrayList();
            if (GenerationActionDelegator.c.REDUCETOSUPERTYPE_SETUNSET_ATTRIBUTES) {
                List easOfConstraintsToConsider;
                EList ownEAttributes = eClass.getEAttributes();
                if (ownEAttributes != null) {
                    easToConsider.addAll(ownEAttributes);
                }
                if ((easOfConstraintsToConsider = ECM.getAllInheritedEAttributesInvolvedInConstraints(eClassifier)) != null) {
                    easToConsider.addAll(easOfConstraintsToConsider);
                }
            } else {
                easToConsider = eClass.getEAllAttributes();
            }
            for (EAttribute ea : easToConsider) {
                if (EMFMetaAccessEx.isUnconsideredStructualFeature((EStructuralFeature)ea)) continue;
                int lowerBound = ea.getLowerBound();
                int upperBound = ea.getUpperBound();
                if (lowerBound == 0 && upperBound == -1) {
                    System.out.println("----------------ea:" + ea.getName() + " of " + ea.eContainer().eClass().getName() + "isMany: [" + lowerBound + "," + upperBound + "]--------------");
                    continue;
                }
                if (lowerBound == 1 && upperBound == -1) {
                    System.out.println("----------------ea:" + ea.getName() + " of " + ea.eContainer().eClass().getName() + "isMany: [" + lowerBound + "," + upperBound + "]--------------");
                    continue;
                }
                if ((lowerBound != 0 || upperBound != 1) && (lowerBound != 1 || upperBound != 1)) continue;
                SetAttributeGenerator generator = new SetAttributeGenerator(eClassifier, ea);
                Module module = generator.generate();
                modules.add(module);
            }
        }
        return modules;
    }

    public Set<Module> generate_UNSET_ATTRIBUTE(Set<Module> setAttributeModules) throws ModuleForInverseCreationRequiredException, OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_UNSET_ATTRIBUTES) {
            if (!GenerationActionDelegator.c.CREATE_SET_ATTRIBUTES) {
                throw new ModuleForInverseCreationRequiredException(OperationType.UNSET_ATTRIBUTE);
            }
            for (Module setAttributeModule : setAttributeModules) {
                UnsetAttributeGenerator generator = new UnsetAttributeGenerator(setAttributeModule);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> generate_SET_REFERENCE(EClass eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_SET_REFERENCES) {
            if (!FILTER.isAllowedAsModuleBasis((EClassifier)eClassifier, OperationType.ADD).booleanValue()) {
                return modules;
            }
            EClass eClass = eClassifier;
            for (EReference eRef : eClass.getEAllReferences()) {
                EClassifier target;
                EReference eOpposite;
                if (EMFMetaAccessEx.isUnconsideredStructualFeature((EStructuralFeature)eRef) || eRef.isContainment() || ((eOpposite = eRef.getEOpposite()) == null || eOpposite.isContainment()) && eOpposite != null || !FILTER.isAllowedAsDangling(target = eRef.getEType(), OperationType.ADD, GenerationActionDelegator.c.REDUCETOSUPERTYPE_ADDREMOVE).booleanValue()) continue;
                int lower = eRef.getLowerBound();
                int upper = eRef.getUpperBound();
                if (eRef.isContainment() || lower != 0 || upper != 1 || eRef.getEOpposite() != null && eRef.getEOpposite().getUpperBound() - eRef.getEOpposite().getLowerBound() > 1 || (!EcoreHelper.isInheritedReference((EReference)eRef, (EClassifier)eClassifier) || GenerationActionDelegator.c.REDUCETOSUPERTYPE_SETUNSET_REFERENCES) && EcoreHelper.isInheritedReference((EReference)eRef, (EClassifier)eClassifier)) continue;
                SetReferenceGenerator generator = new SetReferenceGenerator(eRef, (EClassifier)eClassifier, target);
                modules.add(generator.generate());
            }
        }
        return modules;
    }

    public Set<Module> generate_UNSET_REFERENCE(Set<Module> setReferenceModules) throws OperationTypeNotImplementedException, ModuleForInverseCreationRequiredException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_UNSET_REFERENCES) {
            if (!GenerationActionDelegator.c.CREATE_SET_REFERENCES) {
                throw new ModuleForInverseCreationRequiredException(OperationType.UNSET_REFERENCE);
            }
            for (Module setReferenceModule : setReferenceModules) {
                UnsetReferenceGenerator generator = new UnsetReferenceGenerator(setReferenceModule);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> generate_CHANGE_Literals(EClassifier eClassifier) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_CHANGE_LITERALS) {
            if (!FILTER.isAllowedAsModuleBasis(eClassifier, OperationType.ADD).booleanValue()) {
                return modules;
            }
            EClass eClass = (EClass)eClassifier;
            EList easToConsider = new ArrayList();
            if (GenerationActionDelegator.c.REDUCETOSUPERTYPE_CHANGE_LITERALS) {
                List easOfConstraintsToConsider;
                EList ownEAttributes = eClass.getEAttributes();
                if (ownEAttributes != null) {
                    easToConsider.addAll(ownEAttributes);
                }
                if ((easOfConstraintsToConsider = ECM.getAllInheritedEAttributesInvolvedInConstraints(eClassifier)) != null) {
                    easToConsider.addAll(easOfConstraintsToConsider);
                }
            } else {
                easToConsider = eClass.getEAllAttributes();
            }
            for (EAttribute ea : easToConsider) {
                if (ea.isDerived() || ea.isTransient() || !ea.isChangeable()) continue;
                int lowerBound = ea.getLowerBound();
                int upperBound = ea.getUpperBound();
                if (lowerBound != 1 || upperBound != 1 || !(ea.getEType() instanceof EEnum)) continue;
                EEnum eenum = (EEnum)ea.getEType();
                HashMap combinations = new HashMap();
                for (EEnumLiteral literal : eenum.getELiterals()) {
                    combinations.put(literal, new ArrayList(eenum.getELiterals()));
                }
                for (Map.Entry entry : combinations.entrySet()) {
                    EEnumLiteral oldLiteral = (EEnumLiteral)entry.getKey();
                    ((List)entry.getValue()).remove(oldLiteral);
                    for (EEnumLiteral newLiteral : (List)entry.getValue()) {
                        ChangeLiteralGenerator generator = new ChangeLiteralGenerator(ea, oldLiteral, eClassifier, oldLiteral, newLiteral);
                        modules.add(generator.generate());
                    }
                }
            }
        }
        return modules;
    }

    public Set<Module> generate_CHANGE_Reference(EClass contextClass) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (GenerationActionDelegator.c.CREATE_CHANGE_REFERENCES) {
            if (!FILTER.isAllowedAsModuleBasis((EClassifier)contextClass, OperationType.CHANGE_REFERENCE).booleanValue()) {
                return modules;
            }
            for (EReference eRef : contextClass.getEAllReferences()) {
                if (EMFMetaAccessEx.isUnconsideredStructualFeature((EStructuralFeature)eRef) || eRef.isContainment() || eRef.getEOpposite() != null && eRef.getEOpposite().isContainment() || eRef.getLowerBound() != eRef.getUpperBound() || !FILTER.isAllowedAsDangling((EClassifier)eRef.getEReferenceType(), OperationType.CHANGE_REFERENCE, GenerationActionDelegator.c.REDUCETOSUPERTYPE_CHANGE_REFERENCE).booleanValue() || GenerationActionDelegator.c.REDUCETOSUPERTYPE_CHANGE_REFERENCE && EcoreHelper.isInheritedReference((EReference)eRef, (EClassifier)contextClass)) continue;
                ChangeReferenceGenerator generator = new ChangeReferenceGenerator(eRef, contextClass);
                Module resultModule = generator.generate();
                modules.add(resultModule);
            }
        }
        return modules;
    }

    public Set<Module> process_Replacables(Set<Module> inputModules, OperationType opType, boolean reduceToSuperType) throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        if (!GenerationActionDelegator.c.DISABLE_VARIANTS_BY_SUPERTYPE_REPLACEMENT.booleanValue()) {
            for (Module module : inputModules) {
                VariantGenerator generator = new VariantGenerator(module, opType, reduceToSuperType);
                modules.addAll(generator.generate());
            }
        }
        return modules;
    }
}

