/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.configuration;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.sidiff.common.emf.EMFUtil;
import org.sidiff.common.emf.exceptions.EAttributeNotFoundException;
import org.sidiff.common.emf.exceptions.EClassifierUnresolvableException;
import org.sidiff.common.emf.exceptions.EPackageNotFoundException;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.emf.extensions.impl.Mask;
import org.sidiff.common.emf.modelstorage.ModelStorage;
import org.sidiff.common.io.IOUtil;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.common.xml.XMLParser;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.filter.ElementFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationParser {
    private static Configuration c = Configuration.getInstance();
    private static EClassifierInfoManagement ECM = EClassifierInfoManagement.getInstance();
    private static ElementFilter filter = ElementFilter.getInstance();
    private static Stack<EPackage> calculatedEPackagesStack = new Stack();
    private static List<String> stringWhiteList = new ArrayList<String>();
    private static List<String> stringBlackList = new ArrayList<String>();
    private static String rootName = null;

    public void parse(String pathToConfig) throws Exception {
        EPackage metaModel;
        int i;
        Document doc = XMLParser.parseStream((InputStream)IOUtil.getInputStream((String)pathToConfig));
        Element docElem = doc.getDocumentElement();
        Node currentNode = null;
        NodeList currentChildNodes = null;
        currentNode = doc.getElementsByTagName("preventInconsistency").item(0);
        ConfigurationParser.c.PREVENT_INCONSISTENCY_THROUGHSKIPPING = Boolean.valueOf(this.getAttributeValue("value", currentNode));
        currentNode = doc.getElementsByTagName("multiplicityPreconditions").item(0);
        ConfigurationParser.c.MULTIPLICITY_PRECONDITIONS_INTEGRATED = Boolean.valueOf(this.getAttributeValue("integrated", currentNode));
        ConfigurationParser.c.MULTIPLICITY_PRECONDITIONS_SEPARATELY = Boolean.valueOf(this.getAttributeValue("separately", currentNode));
        currentNode = doc.getElementsByTagName("disableVariantsWithSupertypeReplacement").item(0);
        ConfigurationParser.c.DISABLE_VARIANTS_BY_SUPERTYPE_REPLACEMENT = Boolean.valueOf(this.getAttributeValue("value", currentNode));
        currentNode = doc.getElementsByTagName("createAllAttributes").item(0);
        ConfigurationParser.c.CREATE_NOT_REQUIRED_AND_NOT_ID_ATTRIBUTES = Boolean.valueOf(this.getAttributeValue("value", currentNode));
        currentNode = doc.getElementsByTagName("modelUsesProfileMechanism").item(0);
        ConfigurationParser.c.PROFILE_APPLICATION_IN_USE = Boolean.valueOf(this.getAttributeValue("value", currentNode));
        currentNode = doc.getElementsByTagName("outputFolder").item(0);
        currentNode = doc.getElementsByTagName("reduceToSuperType").item(0);
        ConfigurationParser.c.REDUCETOSUPERTYPE_ADDREMOVE = Boolean.valueOf(this.getAttributeValue("ADD_REMOVE", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_CHANGE_LITERALS = Boolean.valueOf(this.getAttributeValue("CHANGE_LITERAL", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_CHANGE_REFERENCE = Boolean.valueOf(this.getAttributeValue("CHANGE_REFERENCE", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_CREATEDELETE = Boolean.valueOf(this.getAttributeValue("CREATE_DELETE", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_MOVE = Boolean.valueOf(this.getAttributeValue("MOVE", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_MOVE_DOWN = Boolean.valueOf(this.getAttributeValue("MOVE_DOWN", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_MOVE_UP = Boolean.valueOf(this.getAttributeValue("MOVE_UP", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_SETUNSET_ATTRIBUTES = Boolean.valueOf(this.getAttributeValue("SET_UNSET_ATTRIBUTE", currentNode));
        ConfigurationParser.c.REDUCETOSUPERTYPE_SETUNSET_REFERENCES = Boolean.valueOf(this.getAttributeValue("SET_UNSET_REFERENCE", currentNode));
        currentNode = doc.getElementsByTagName("Creates").item(0);
        ConfigurationParser.c.CREATE_CREATES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("Deletes").item(0);
        ConfigurationParser.c.CREATE_DELETES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("Moves").item(0);
        ConfigurationParser.c.CREATE_MOVES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        ConfigurationParser.c.REFERENCESWITCHING_MOVE = Boolean.valueOf(this.getAttributeValue("allowReferenceSwitching", currentNode));
        ConfigurationParser.c.CREATE_MOVE_REFERENCE_COMBINATIONS = Boolean.valueOf(this.getAttributeValue("allowReferenceCombinations", currentNode));
        currentNode = doc.getElementsByTagName("MoveUps").item(0);
        ConfigurationParser.c.CREATE_MOVE_UPS = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        ConfigurationParser.c.REFERENCESWITCHING_MOVE = Boolean.valueOf(this.getAttributeValue("allowReferenceSwitching", currentNode));
        currentNode = doc.getElementsByTagName("MoveDowns").item(0);
        ConfigurationParser.c.CREATE_MOVE_DOWNS = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        ConfigurationParser.c.REFERENCESWITCHING_MOVE = Boolean.valueOf(this.getAttributeValue("allowReferenceSwitching", currentNode));
        currentNode = doc.getElementsByTagName("ChangeLiterals").item(0);
        ConfigurationParser.c.CREATE_CHANGE_LITERALS = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        ConfigurationParser.c.LITERALSWITCHING_CHANGE = Boolean.valueOf(this.getAttributeValue("allowLiteralSwitching", currentNode));
        currentNode = doc.getElementsByTagName("ChangeReferences").item(0);
        ConfigurationParser.c.CREATE_CHANGE_REFERENCES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("Adds").item(0);
        ConfigurationParser.c.CREATE_ADDS = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("Removes").item(0);
        ConfigurationParser.c.CREATE_REMOVES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("SetAttributes").item(0);
        ConfigurationParser.c.CREATE_SET_ATTRIBUTES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("SetReferences").item(0);
        ConfigurationParser.c.CREATE_SET_REFERENCES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("UnsetAttributes").item(0);
        ConfigurationParser.c.CREATE_UNSET_ATTRIBUTES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        currentNode = doc.getElementsByTagName("UnsetReferences").item(0);
        ConfigurationParser.c.CREATE_UNSET_REFERENCES = Boolean.valueOf(this.getAttributeValue("allow", currentNode));
        if (ConfigurationParser.c.PROFILE_APPLICATION_IN_USE.booleanValue()) {
            currentNode = doc.getElementsByTagName("BaseModelRules").item(0);
            ConfigurationParser.c.BASEMODELRULEFOLDERPATH = String.valueOf(this.getAttributeValue("path", currentNode));
        }
        if ((currentNode = docElem.getElementsByTagName("BlackList").item(0)) != null) {
            currentChildNodes = currentNode.getChildNodes();
            i = 0;
            while (i < currentChildNodes.getLength()) {
                if (currentChildNodes.item(i).getNodeName().equals("EClassifier")) {
                    stringBlackList.add(this.getAttributeValue("name", currentChildNodes.item(i)));
                }
                ++i;
            }
        }
        currentNode = docElem.getElementsByTagName("WhiteList").item(0);
        currentChildNodes = currentNode.getChildNodes();
        i = 0;
        while (i < currentChildNodes.getLength()) {
            if (currentChildNodes.item(i).getNodeName().equals("EClassifier")) {
                stringWhiteList.add(this.getAttributeValue("name", currentChildNodes.item(i)));
            }
            ++i;
        }
        currentNode = doc.getElementsByTagName("MainModel").item(0);
        String nsUri = String.valueOf(this.getAttributeValue("nsUri", currentNode));
        ConfigurationParser.c.METAMODEL = metaModel = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        calculatedEPackagesStack.add(metaModel);
        try {
            calculatedEPackagesStack.addAll(EMFUtil.getAllSubEPackages((EPackage)metaModel));
        }
        catch (EPackageNotFoundException e) {
            e.printStackTrace();
        }
        NodeList requiredModelNodes = doc.getElementsByTagName("RequiredModel");
        int i2 = 0;
        while (i2 <= requiredModelNodes.getLength() - 1) {
            Node requiredNode = requiredModelNodes.item(i2);
            String uri = String.valueOf(this.getAttributeValue("nsUri", requiredNode));
            EPackage reqModel = EPackage.Registry.INSTANCE.getEPackage(uri);
            if (reqModel == null) {
                throw new EPackageNotFoundException(uri);
            }
            if (!calculatedEPackagesStack.contains(reqModel)) {
                calculatedEPackagesStack.add(reqModel);
            }
            ++i2;
        }
        currentNode = docElem.getElementsByTagName("Root").item(0);
        rootName = String.valueOf(this.getAttributeValue("name", currentNode));
        if (!rootName.equals("")) {
            EClassifier root;
            Configuration.ROOT = root = ConfigurationParser.resolveStringAsEClassifier(rootName, calculatedEPackagesStack);
        }
        Configuration.ROOTECLASSCANBENESTED = Boolean.valueOf(this.getAttributeValue("nested", currentNode));
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Analyzing Meta-Model..."});
        ConfigurationParser.gatherAllRequiredEPackages(metaModel);
        ConfigurationParser.c.EPACKAGESSTACK = calculatedEPackagesStack;
        ConfigurationParser.unfoldBlackList();
        ConfigurationParser.unfoldWhiteList();
        currentNode = docElem.getElementsByTagName("MaskedClassifiers").item(0);
        if (currentNode != null) {
            currentChildNodes = currentNode.getChildNodes();
            i = 0;
            while (i < currentChildNodes.getLength()) {
                if (currentChildNodes.item(i).getNodeName().equals("Mask")) {
                    Node maskNode = currentChildNodes.item(i);
                    String maskName = this.getAttributeValue("name", maskNode);
                    String eClassName = this.getAttributeValue("eClassifier", maskNode);
                    String eAttributeName = this.getAttributeValue("eAttribute", maskNode);
                    String eAttributeValue = this.getAttributeValue("eAttributeValue", maskNode);
                    EClassifier maskContainer = ConfigurationParser.resolveStringAsEClassifier(eClassName, calculatedEPackagesStack);
                    EAttribute eAttribute = (EAttribute)((EClass)maskContainer).getEStructuralFeature(eAttributeName);
                    EClassifier valueContainer = eAttribute.getEType();
                    EEnumLiteral valueLiteral = null;
                    if (!(valueContainer instanceof EEnum)) {
                        throw new Exception("Masked Classifier contains type information that is not represented by EEnum(Literals)");
                    }
                    valueLiteral = ((EEnum)valueContainer).getEEnumLiteral(eAttributeValue);
                    Mask mask = new Mask(maskName, maskContainer, eAttribute, valueLiteral);
                    ECM.getEClassifierInfo(maskContainer).addMask(mask);
                }
                ++i;
            }
        }
        NodeList c_nameUniqueness = doc.getElementsByTagName("NameUniqueness");
        int i3 = 0;
        while (i3 <= c_nameUniqueness.getLength() - 1) {
            Node c = c_nameUniqueness.item(i3);
            String scope = String.valueOf(this.getAttributeValue("scope", c));
            String eClass = String.valueOf(this.getAttributeValue("eClassifier", c));
            String eAttributeName = String.valueOf(this.getAttributeValue("eAttributeName", c));
            Boolean eAttributeIsInherited = Boolean.valueOf(this.getAttributeValue("eAttributeIsInherited", c));
            Boolean overrideInheritedConstraints = Boolean.valueOf(this.getAttributeValue("overrideInheritedConstraintsIfAny", c));
            Boolean applyOnSubTypes = Boolean.valueOf(this.getAttributeValue("applyOnSubTypes", c));
            EClass constrainedEClass = null;
            EAttribute constrainedEAttribute = null;
            if (!eClass.equals("")) {
                for (EPackage ePackage : calculatedEPackagesStack) {
                    constrainedEClass = (EClass)ePackage.getEClassifier(eClass);
                    if (constrainedEClass == null) continue;
                    if (eAttributeIsInherited.booleanValue()) {
                        for (EClass superType : constrainedEClass.getEAllSuperTypes()) {
                            for (EAttribute ea : superType.getEAttributes()) {
                                if (!ea.getName().equals(eAttributeName)) continue;
                                constrainedEAttribute = ea;
                                break;
                            }
                            if (constrainedEAttribute == null) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (EAttribute ea : constrainedEClass.getEAttributes()) {
                            if (!ea.getName().equals(eAttributeName)) continue;
                            constrainedEAttribute = ea;
                            break;
                        }
                    }
                    if (constrainedEAttribute != null) break;
                    throw new EAttributeNotFoundException(eAttributeName, constrainedEClass);
                }
                if (constrainedEClass == null) {
                    throw new EClassifierUnresolvableException(eClass);
                }
            }
            ArrayList<Boolean> flags = new ArrayList<Boolean>();
            flags.add(applyOnSubTypes);
            flags.add((Boolean)constrainedEAttribute);
            flags.add(overrideInheritedConstraints);
            flags.add(eAttributeIsInherited);
            if (scope.equals("global")) {
                ECM.addConstraint(EClassifierInfo.ConstraintType.NAME_UNIQUENESS_GLOBAL, (EClassifier)constrainedEClass, flags);
            } else {
                ECM.addConstraint(EClassifierInfo.ConstraintType.NAME_UNIQUENESS_LOCAL, (EClassifier)constrainedEClass, flags);
            }
            ++i3;
        }
    }

    private static void gatherAllRequiredEPackages(EPackage metaModel) {
        ArrayList<EPackage> subPackages = new ArrayList<EPackage>();
        for (EPackage ep : calculatedEPackagesStack) {
            for (EPackage sub : ep.getESubpackages()) {
                if (subPackages.contains(sub) || calculatedEPackagesStack.contains(sub)) continue;
                subPackages.add(sub);
            }
        }
        calculatedEPackagesStack.addAll(subPackages);
        Map map = EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)metaModel);
        for (Map.Entry entry : map.entrySet()) {
            for (EStructuralFeature.Setting setting : (Collection)entry.getValue()) {
                EClassifier targetedClassifier = setting.getEStructuralFeature().getEType();
                if (targetedClassifier.eIsProxy()) {
                    EPackage p;
                    String absolutPathOfMetaModel = metaModel.eResource().getURI().toString();
                    String completePath = ConfigurationParser.convertEProxyURIToFilePath(targetedClassifier.toString(), absolutPathOfMetaModel);
                    File ecoreFile = new File(completePath);
                    assert (ecoreFile != null) : "The Metamodel uses other ecore files that are not inside your workspace or enabled in the run configuration";
                    String modelKey = ModelStorage.getInstance().loadEMF(ecoreFile.getPath());
                    Resource referencedEcoreRes = ModelStorage.getInstance().getModel(modelKey);
                    EObject eObject = (EObject)referencedEcoreRes.getContents().get(0);
                    if (!(eObject instanceof EPackage) || EPackage.Registry.INSTANCE.containsKey((Object)(p = (EPackage)eObject).getNsURI())) continue;
                    EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
                    if (calculatedEPackagesStack.contains(p)) continue;
                    calculatedEPackagesStack.add(p);
                    continue;
                }
                if (calculatedEPackagesStack.contains(targetedClassifier.getEPackage())) continue;
                calculatedEPackagesStack.add(targetedClassifier.getEPackage());
            }
        }
    }

    private static void unfoldBlackList() throws EClassifierUnresolvableException {
        filter.setBlackList(new ArrayList<EClassifier>());
        for (String eClassName : stringBlackList) {
            EClassifier skip = ConfigurationParser.resolveStringAsEClassifier(eClassName, calculatedEPackagesStack);
            filter.getBlackList().add(skip);
        }
        if (ConfigurationParser.c.PREVENT_INCONSISTENCY_THROUGHSKIPPING) {
            filter.setBlackList(ConfigurationParser.findMoreSkips(filter.getBlackList()));
        }
    }

    private static void unfoldWhiteList() throws EClassifierUnresolvableException {
        filter.setWhiteList(new ArrayList<EClassifier>());
        for (String eClassName : stringWhiteList) {
            EClassifier eClassifier = ConfigurationParser.resolveStringAsEClassifier(eClassName, calculatedEPackagesStack);
            filter.getWhiteList().add(eClassifier);
        }
    }

    private static ArrayList<EClassifier> findMoreSkips(List<EClassifier> oldList) {
        ArrayList<EClassifier> extendedSkipList = new ArrayList<EClassifier>();
        extendedSkipList.addAll(oldList);
        boolean newEntries = false;
        for (EClassifier skip : oldList) {
            EClassifierInfo skipInfo = ECM.getEClassifierInfo(skip);
            for (List mpcList : skipInfo.getMandatoryParentContext().values()) {
                for (EClassifier mpc : mpcList) {
                    if (oldList.contains(mpc) || stringWhiteList.contains(mpc.getName()) || mpc.equals(rootName)) continue;
                    extendedSkipList.add(mpc);
                    newEntries = true;
                }
            }
            for (List mpcList : skipInfo.getMandatoryNeighbourContext().values()) {
                for (EClassifier mnc : mpcList) {
                    if (oldList.contains(mnc) || stringWhiteList.contains(mnc.getName()) || mnc.equals(rootName)) continue;
                    extendedSkipList.add(mnc);
                    newEntries = true;
                }
            }
        }
        if (newEntries) {
            extendedSkipList = ConfigurationParser.findMoreSkips(extendedSkipList);
        }
        return extendedSkipList;
    }

    private String getAttributeValue(String attribName, Node node) {
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            if (attribs.item(i).getNodeName().equals(attribName)) {
                return attribs.item(i).getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private static EClassifier resolveStringAsEClassifier(String eClassifierName, Stack<EPackage> ePackagesStack) throws EClassifierUnresolvableException {
        EClassifier resolvedEClassifier = null;
        for (EPackage ePackage : ePackagesStack) {
            resolvedEClassifier = ePackage.getEClassifier(eClassifierName);
            if (resolvedEClassifier == null) continue;
            return resolvedEClassifier;
        }
        throw new EClassifierUnresolvableException(eClassifierName);
    }

    private static String convertEProxyURIToFilePath(String eProxyURIString, String containingMetaModelPath) {
        String formerWorkspacke_loc = "";
        String proxyUri = eProxyURIString;
        proxyUri = proxyUri.replaceFirst("[\\w\\.@\\s\\(:]*[plugin/]+/", "");
        proxyUri = proxyUri.replaceFirst("#[\\/]{2}[\\w\\d]*[\\)]$", "");
        String FILE_SEPERATOR = System.getProperty("file.separator");
        if (!FILE_SEPERATOR.equals("/")) {
            proxyUri = proxyUri.replace("/", "\\");
        }
        return String.valueOf(formerWorkspacke_loc) + FILE_SEPERATOR + proxyUri;
    }
}

