/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.emf.ecore.EClassVisitor;
import org.sidiff.common.emf.ecore.ECoreTraversal;
import org.sidiff.common.emf.exceptions.EPackageNotFoundException;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.io.IOUtil;
import org.sidiff.common.io.ResourceUtil;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.common.xml.XMLResolver;
import org.sidiff.editrule.generator.IEditRuleGenerator;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.configuration.ConfigurationParser;
import org.sidiff.editrule.generator.serge.core.ConstraintApplicator;
import org.sidiff.editrule.generator.serge.core.InverseModuleMapSerializer;
import org.sidiff.editrule.generator.serge.core.InverseModuleMapper;
import org.sidiff.editrule.generator.serge.core.MainUnitApplicator;
import org.sidiff.editrule.generator.serge.core.MetaModelElementVisitor;
import org.sidiff.editrule.generator.serge.core.ModuleSerializer;
import org.sidiff.editrule.generator.serge.core.NameMapper;
import org.sidiff.editrule.generator.serge.core.RuleParameterApplicator;
import org.sidiff.editrule.generator.serge.filter.DuplicateFilter;
import org.sidiff.editrule.generator.serge.filter.ElementFilter;
import org.sidiff.editrule.generator.serge.filter.ExecutableFilter;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;
import org.sidiff.editrule.generator.settings.EditRuleGenerationSettings;
import org.sidiff.editrule.generator.types.OperationType;

public class Serge
implements IEditRuleGenerator {
    public static final String PLUGIN_NAME = "org.sidiff.editrule.generator.serge";
    public static final String GENERATOR_KEY = "serge";
    private static Stack<EPackage> ePackagesStack = null;
    private static Configuration config = null;
    private SergeSettings settings = null;

    public void init(EditRuleGenerationSettings settings, IProgressMonitor monitor) {
        monitor.beginTask("Initializing SERGe", 100);
        monitor.subTask("Loading Configuration");
        ResourceUtil.registerClassLoader((ClassLoader)this.getClass().getClassLoader());
        XMLResolver.getInstance().includeMapping(IOUtil.getInputStream((String)"platform:/plugin/org.sidiff.editrule.generator.serge/config/Editrulesgeneratorconfig.dtdmap.xml"));
        if (settings instanceof EditRuleGenerationSettings) {
            this.settings = new SergeSettings(settings.getGenerator(), settings.getOutputFolderPath(), settings.getConfigPath(), settings.isUseSubfolders());
        }
        assert (this.settings != null) : "This is no valid SergeSettings Instance:" + settings.toString();
        try {
            try {
                config = Configuration.getInstance();
                EClassifierInfoManagement ECM = EClassifierInfoManagement.getInstance();
                ElementFilter.getInstance();
                ConfigurationParser parser = new ConfigurationParser();
                parser.parse(this.settings.getConfigPath());
                monitor.worked(20);
                monitor.subTask("Analyzing MetaModel");
                ECM.gatherInformation(Serge.config.PROFILE_APPLICATION_IN_USE, Serge.config.EPACKAGESSTACK, Boolean.valueOf(Serge.config.ENABLE_INNER_CONTAINMENT_CYCLE_DETECTION));
                ePackagesStack = Serge.config.EPACKAGESSTACK;
                monitor.worked(80);
            }
            catch (Exception e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void generateEditRules(IProgressMonitor monitor) throws IOException, EPackageNotFoundException, OperationTypeNotImplementedException {
        HashSet<Module> moduleSet;
        monitor.beginTask("Generating CPEOs", 100);
        if (ePackagesStack != null && !ePackagesStack.isEmpty()) {
            monitor.subTask("Visit MetaModel elements");
            MetaModelElementVisitor eClassVisitor = new MetaModelElementVisitor();
            ECoreTraversal.traverse((EClassVisitor)eClassVisitor, (EPackage[])ePackagesStack.toArray(new EPackage[ePackagesStack.size()]));
            monitor.worked(50);
            Map<OperationType, Set<Module>> allModules = eClassVisitor.getAllModules();
            if (Serge.config.MULTIPLICITY_PRECONDITIONS_INTEGRATED) {
                monitor.subTask("Applying Constraints");
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Constraint Applicator --"});
                ConstraintApplicator constraintApplicator = new ConstraintApplicator();
                constraintApplicator.applyOn(allModules);
                monitor.worked(5);
            }
            if (Serge.config.ENABLE_EXECUTION_CHECK_FILTER) {
                monitor.subTask("Filtering Executions");
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Execution Filter --"});
                ExecutableFilter executionFilter = new ExecutableFilter();
                executionFilter.applyOn(allModules);
                monitor.worked(5);
            }
            if (Serge.config.ENABLE_DUPLICATE_FILTER) {
                monitor.subTask("Filtering Duplicates");
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Duplicate Filter --"});
                DuplicateFilter duplicateFilter = new DuplicateFilter();
                duplicateFilter.filterIdenticalByName(allModules);
                duplicateFilter.filterAddSet(allModules.get(OperationType.ADD), allModules.get(OperationType.SET_REFERENCE));
                duplicateFilter.filterRemoveUnset(allModules.get(OperationType.REMOVE), allModules.get(OperationType.UNSET_REFERENCE));
                monitor.worked(5);
            }
            monitor.subTask("Applying Rule Parameter");
            LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Rule Parameter Applicator --"});
            RuleParameterApplicator ruleParameterApplicator = new RuleParameterApplicator();
            ruleParameterApplicator.applyOn(allModules);
            monitor.worked(5);
            monitor.subTask("Applying Main Unit");
            LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Main Unit Applicator --"});
            MainUnitApplicator mainUnitApplicator = new MainUnitApplicator();
            mainUnitApplicator.applyOn(allModules);
            monitor.worked(5);
            if (this.settings.isSaveLogs()) {
                monitor.subTask("Logging Inverse Modules");
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Inverse Module Log Serializer --"});
                InverseModuleMapper inverseModuleMapper = new InverseModuleMapper();
                inverseModuleMapper.findAndMapInversePairs(allModules);
                InverseModuleMapSerializer inverseModuleSerializer = new InverseModuleMapSerializer(this.settings);
                inverseModuleSerializer.serialize(inverseModuleMapper);
                String timestamp = new SimpleDateFormat("YYYYMMdd").format(new Date());
                Path sourceConfig = Paths.get(this.settings.getConfigPath(), new String[0]);
                Path targetConfig = Paths.get(String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator") + "usedConfig" + "_" + timestamp + ".serge", new String[0]);
                if (Files.exists(targetConfig, new LinkOption[0]) && !this.settings.isOverwriteConfigInTargetFolder()) {
                    timestamp = new SimpleDateFormat("YYYYMMdd_hhmmss").format(new Date());
                    targetConfig = Paths.get(String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator") + "usedConfig" + "_" + timestamp + ".serge", new String[0]);
                }
                Files.copy(sourceConfig, targetConfig, StandardCopyOption.REPLACE_EXISTING);
                monitor.worked(5);
            }
            if (this.settings.isDeleteManualTransformations()) {
                monitor.subTask("Deleting Manual Transformations");
                File manualFolder = new File(String.valueOf(this.settings.getOutputFolderPath()) + "manual");
                if (manualFolder.exists()) {
                    File[] fileArray = manualFolder.listFiles();
                    int sourceConfig = fileArray.length;
                    int n = 0;
                    while (n < sourceConfig) {
                        File f = fileArray[n];
                        f.delete();
                        ++n;
                    }
                }
                monitor.worked(5);
            }
            moduleSet = new HashSet<Module>();
            for (OperationType opType : allModules.keySet()) {
                Set<Module> opSet = allModules.get(opType);
                if (opSet.isEmpty()) continue;
                moduleSet.addAll(opSet);
            }
            if (Serge.config.ENABLE_NAME_MAPPER) {
                monitor.subTask("Mapping Names");
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Name Mapper --"});
                NameMapper nameMapper = new NameMapper(Configuration.getInstance().METAMODEL, moduleSet);
                nameMapper.replaceNames();
                monitor.worked(5);
            }
        } else {
            monitor.done();
            throw new EPackageNotFoundException();
        }
        monitor.subTask("Saving Edit Rules");
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"-- Module Serializer --"});
        ModuleSerializer serializer = new ModuleSerializer(this.settings);
        serializer.serialize(moduleSet);
        monitor.worked(10);
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"SERGe DONE.."});
        monitor.done();
    }

    public String getName() {
        return "SERGe (SiDiff EditRule Generator)";
    }

    public String getKey() {
        return GENERATOR_KEY;
    }
}

