/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.eclipse.integrator.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;
import org.sidiff.eclipse.integrator.Activator;
import org.sidiff.eclipse.integrator.BundleHandler;

public class SiDiffPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ArrayList<Bundle> siDiffBundles;
    private HashMap<String, Bundle> sidiffBundlesMap;

    protected Control createContents(Composite parent) {
        this.sidiffBundlesMap = new HashMap();
        Composite container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, false);
        container.setLayout((Layout)grid);
        final Table table = new Table(container, 67618);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        String[] titles = new String[]{" ", "ID", "Name", "Status"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        this.siDiffBundles = BundleHandler.getInstance().getSiDiffBundles();
        for (Bundle bundle : this.siDiffBundles) {
            TableItem item = new TableItem(table, 0);
            item.setText(1, Long.toString(bundle.getBundleId()));
            item.setText(2, bundle.getSymbolicName());
            item.setText(3, BundleHandler.getInstance().getState(bundle));
            this.sidiffBundlesMap.put(bundle.getSymbolicName(), bundle);
        }
        i = 0;
        while (i < titles.length) {
            table.getColumn(i).pack();
            ++i;
        }
        Composite buttons = new Composite(parent, 0);
        GridLayout buttonsGrid = new GridLayout(5, false);
        buttons.setLayout((Layout)buttonsGrid);
        GridData buttonsGridData = new GridData(4, 4, true, true, 2, 1);
        Button selectAll = new Button(buttons, 0);
        selectAll.setText("select all");
        selectAll.setLayoutData((Object)buttonsGridData);
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText("select none");
        deselectAll.setLayoutData((Object)buttonsGridData);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiDiffPreferences.this.setSelect(true, table);
            }
        });
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiDiffPreferences.this.setSelect(false, table);
            }
        });
        Button startAll = new Button(buttons, 8);
        startAll.setText("start all");
        startAll.setLayoutData((Object)buttonsGridData);
        startAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().startBundles();
            }
        });
        Button startSelected = new Button(buttons, 8);
        startSelected.setText("start selected");
        startSelected.setLayoutData((Object)buttonsGridData);
        startSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().startBundles(SiDiffPreferences.this.getSelectedBundles(table));
            }
        });
        Button stopAll = new Button(buttons, 8);
        stopAll.setText("stop all");
        stopAll.setLayoutData((Object)buttonsGridData);
        stopAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().stopBundles();
            }
        });
        Button stopSelected = new Button(buttons, 8);
        stopSelected.setText("stop selected");
        stopSelected.setLayoutData((Object)buttonsGridData);
        stopSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().stopBundles(SiDiffPreferences.this.getSelectedBundles(table));
            }
        });
        Button refreshAll = new Button(buttons, 8);
        refreshAll.setText("restart all");
        refreshAll.setLayoutData((Object)buttonsGridData);
        refreshAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().refreshBundles();
            }
        });
        Button refreshSelected = new Button(buttons, 8);
        refreshSelected.setText("restart selected");
        refreshSelected.setLayoutData((Object)buttonsGridData);
        refreshSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleHandler.getInstance().refreshBundles(SiDiffPreferences.this.getSelectedBundles(table));
            }
        });
        container.pack();
        return container;
    }

    private void setSelect(boolean select, Table table) {
        TableItem[] items;
        TableItem[] tableItemArray = items = table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            tableItem.setChecked(select);
            ++n2;
        }
    }

    private ArrayList<Bundle> getSelectedBundles(Table table) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                result.add(this.sidiffBundlesMap.get(tableItem.getText(2)));
            }
            ++n2;
        }
        System.out.println("Result contains " + result.size() + " Elements!!");
        return result;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getStore());
    }
}

