/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.eclipse.integrator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.sidiff.eclipse.integrator.Activator;
import org.sidiff.eclipse.integrator.IntegratorUtil;

public class BundleHandler {
    private static BundleHandler instance = null;
    private Logger logger = Logger.getLogger("org.sidiff.eclipse.integrator.BundleHandler");

    private BundleHandler() {
    }

    public static BundleHandler getInstance() {
        if (instance == null) {
            instance = new BundleHandler();
        }
        return instance;
    }

    public void startBundles() {
        Bundle[] bundles;
        this.logger.log(Level.INFO, "Starting every SiDiff Bundle!");
        ArrayList<Bundle> bundleToStart = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles = Activator.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (IntegratorUtil.isSiDiffMatchingEngineBundle(bundle)) {
                bundleToStart.add(bundle);
            }
            ++n2;
        }
        long time2 = System.currentTimeMillis();
        for (Bundle bundle : bundleToStart) {
            try {
                if (bundle.getState() == 32) continue;
                long time1 = time2;
                bundle.start();
                time2 = System.currentTimeMillis();
                this.logger.log(Level.INFO, "Started '" + bundle.getSymbolicName() + "' (" + (time2 - time1) + " ms)");
            }
            catch (BundleException bundleException) {}
        }
        this.logger.log(Level.INFO, "Starting of every SiDiff Bundle is finished now!");
    }

    public void startBundles(ArrayList<Bundle> bundles) {
        this.logger.log(Level.INFO, "Starting a List of SiDiff Bundles!");
        long time2 = System.currentTimeMillis();
        for (Bundle bundle : bundles) {
            try {
                if (bundle.getState() == 32) continue;
                long time1 = time2;
                bundle.start();
                time2 = System.currentTimeMillis();
                this.logger.log(Level.INFO, "Started '" + bundle.getSymbolicName() + "' (" + (time2 - time1) + " ms)");
            }
            catch (BundleException bundleException) {}
        }
        this.logger.log(Level.INFO, "Starting of the List of SiDiff Bundles is finished now!");
    }

    public void stopBundles() {
        Bundle[] bundles;
        this.logger.log(Level.INFO, "Stopping every SiDiff Bundle!");
        ArrayList<Bundle> bundleToStart = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles = Activator.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (IntegratorUtil.isSiDiffMatchingEngineBundle(bundle)) {
                bundleToStart.add(bundle);
            }
            ++n2;
        }
        long time2 = System.currentTimeMillis();
        for (Bundle bundle : bundleToStart) {
            try {
                if (bundle.getState() != 32) continue;
                long time1 = time2;
                bundle.stop();
                time2 = System.currentTimeMillis();
                this.logger.log(Level.INFO, "Stopping '" + bundle.getSymbolicName() + "' (" + (time2 - time1) + " ms)");
            }
            catch (BundleException bundleException) {}
        }
        this.logger.log(Level.INFO, "Stopping of every SiDiff Bundle is finished now!");
    }

    public void stopBundles(ArrayList<Bundle> bundles) {
        this.logger.log(Level.INFO, "Stopping a List of SiDiff Bundles!");
        long time2 = System.currentTimeMillis();
        for (Bundle bundle : bundles) {
            try {
                if (bundle.getState() != 32) continue;
                long time1 = time2;
                bundle.stop();
                time2 = System.currentTimeMillis();
                this.logger.log(Level.INFO, "Stopping '" + bundle.getSymbolicName() + "' (" + (time2 - time1) + " ms)");
            }
            catch (BundleException bundleException) {}
        }
        this.logger.log(Level.INFO, "Stopping of the List of SiDiff Bundles is finished now!");
    }

    public void refreshBundles() {
        this.logger.log(Level.INFO, "Refreshing every SiDiff Bundle!");
        this.stopBundles();
        this.startBundles();
        this.logger.log(Level.INFO, "Refreshing of all SiDiff Bundles is finished now!");
    }

    public void refreshBundles(ArrayList<Bundle> bundles) {
        if (bundles.isEmpty()) {
            this.logger.log(Level.INFO, "List of refreshing Bundles is empty!");
        } else {
            this.logger.log(Level.INFO, "Refreshing a List of SiDiff Bundles!");
            this.stopBundles(bundles);
            this.startBundles(bundles);
            this.logger.log(Level.INFO, "Refreshing of the List of SiDiff Bundles is finished now!");
        }
    }

    public ArrayList<Bundle> getSiDiffBundles() {
        Bundle[] bundles;
        ArrayList<Bundle> sidiffBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles = Activator.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (IntegratorUtil.isSiDiffMatchingEngineBundle(bundle)) {
                sidiffBundles.add(bundle);
            }
            ++n2;
        }
        return sidiffBundles;
    }

    public String getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
        }
        return "either one";
    }

    public ArrayList<Bundle> getBundleList(ArrayList<String> bundles) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        ArrayList<Bundle> siDiffBundles = this.getSiDiffBundles();
        HashMap<String, Bundle> bundleMap = new HashMap<String, Bundle>();
        for (Bundle bundle : siDiffBundles) {
            bundleMap.put(bundle.getSymbolicName(), bundle);
        }
        for (String string : bundles) {
            result.add((Bundle)bundleMap.get(string));
        }
        return result;
    }
}

