/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;

public class SergeWizardPage2
extends WizardPage {
    private ISelection selection;
    private SergeSettings settings;

    public SergeWizardPage2(ISelection selection, SergeSettings settings) {
        super("wizardPage");
        this.setTitle("SERGe CPEO Generation Wizard");
        this.setDescription("Please define advanced settings for the generation.");
        this.selection = selection;
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        this.initialize();
        this.setControl((Control)container);
        Group grpTransformationSettings = new Group(container, 4);
        grpTransformationSettings.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpTransformationSettings = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_grpTransformationSettings.widthHint = 424;
        grpTransformationSettings.setLayoutData((Object)gd_grpTransformationSettings);
        grpTransformationSettings.setText("Transformation Settings");
        Button cbtnDeleteExisting = new Button((Composite)grpTransformationSettings, 32);
        cbtnDeleteExisting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        cbtnDeleteExisting.setText("Delete existing, manually created transformations ");
        cbtnDeleteExisting.setSelection(this.settings.isDeleteManualTransformations());
        Button btnDeleteExisting = new Button((Composite)grpTransformationSettings, 16);
        btnDeleteExisting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        btnDeleteExisting.setText("Delete existing, generated transformations");
        btnDeleteExisting.setSelection(this.settings.isDeleteGeneratedTransformations());
        Button btnKeepExisting = new Button((Composite)grpTransformationSettings, 16);
        btnKeepExisting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        btnKeepExisting.setText("Keep existing, generated transformations");
        btnKeepExisting.setSelection(!this.settings.isDeleteGeneratedTransformations());
        Composite composite = new Composite((Composite)grpTransformationSettings, 0);
        GridData gd_composite = new GridData(16384, 4, false, false, 1, 1);
        gd_composite.widthHint = 31;
        gd_composite.heightHint = 5;
        composite.setLayoutData((Object)gd_composite);
        Button cbtnOverwriteExisting = new Button((Composite)grpTransformationSettings, 32);
        GridData gd_cbtnOverwriteExisting = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cbtnOverwriteExisting.widthHint = 506;
        cbtnOverwriteExisting.setLayoutData((Object)gd_cbtnOverwriteExisting);
        cbtnOverwriteExisting.setText("Overwrite existing, generated transformation");
        cbtnOverwriteExisting.setSelection(this.settings.isOverwriteGeneratedTransformations());
        Group grpConfigSerialization = new Group(container, 4);
        grpConfigSerialization.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpConfigSerialization.setText("Config Serialization");
        grpConfigSerialization.setLayout((Layout)new GridLayout(1, false));
        Button cbtnOverwriteExistingConfig = new Button((Composite)grpConfigSerialization, 32);
        cbtnOverwriteExistingConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        cbtnOverwriteExistingConfig.setText("Overwrite existing config");
        cbtnOverwriteExistingConfig.setSelection(this.settings.isOverwriteConfigInTargetFolder());
        Group grpLogSerialization = new Group(container, 4);
        grpLogSerialization.setLayout((Layout)new GridLayout(1, false));
        GridData gd_grpLogSerialization = new GridData(4, 4, true, false, 1, 1);
        gd_grpLogSerialization.widthHint = 184;
        grpLogSerialization.setLayoutData((Object)gd_grpLogSerialization);
        grpLogSerialization.setText("Log Serialization");
        Button cbtnSaveLog = new Button((Composite)grpLogSerialization, 32);
        cbtnSaveLog.setText("Save logs");
        cbtnSaveLog.setSelection(this.settings.isSaveLogs());
        Button cbtnDeletePreviousTags = new Button((Composite)grpLogSerialization, 32);
        cbtnDeletePreviousTags.setText("Delete previous logs");
        cbtnDeletePreviousTags.setSelection(this.settings.isDeleteLogs());
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer cfr_ignored_0 = (IContainer)obj;
                } else {
                    ((IResource)obj).getParent();
                }
            }
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("serge")) {
            this.updateStatus("File extension must be \"serge\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return null;
    }

    public String getFileName() {
        return null;
    }
}

