/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;
import org.sidiff.editrule.generator.settings.EditRuleGenerationSettings;
import org.sidiff.editrule.generator.ui.widgets.EditRuleGeneratorSettingsWidget;

public class SergeWizardPage1
extends WizardPage {
    private ISelection selection;
    private Text txtSelectOutputFolder;
    private ModifyListener validationListener;
    private SergeSettings settings;
    private EditRuleGeneratorSettingsWidget configWidget;

    public SergeWizardPage1(ISelection selection, SergeSettings settings) {
        super("wizardPage");
        this.setTitle("SERGe CPEO Generation Wizard");
        this.setDescription("Please define general settings for the generation.");
        this.selection = selection;
        this.settings = settings;
    }

    private void validate() {
        Boolean valid = false;
        this.configWidget.getSettings();
        valid = this.configWidget.validate();
        this.setErrorMessage(this.configWidget.getValidationMessage());
        if (this.txtSelectOutputFolder.getText().length() == 0) {
            this.setErrorMessage("Output Folder Path is missing.");
            valid = false;
        }
        this.setPageComplete(valid);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.initialize();
        this.setControl((Control)container);
        this.setPageComplete(false);
        final DirectoryDialog eOutputFolderChooser = new DirectoryDialog(this.getShell());
        container.setLayout((Layout)new GridLayout(1, false));
        Composite cOutput = new Composite(container, 0);
        cOutput.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        cOutput.setLayout((Layout)new GridLayout(1, false));
        Group grpOutputPaths = new Group(cOutput, 0);
        grpOutputPaths.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpOutputPaths.setLayout((Layout)new GridLayout(1, false));
        grpOutputPaths.setText("Output");
        Composite composite = new Composite((Composite)grpOutputPaths, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite config = new Composite(container, 65536);
        config.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        config.setLayout((Layout)new GridLayout(1, false));
        this.configWidget = new EditRuleGeneratorSettingsWidget((EditRuleGenerationSettings)this.settings);
        this.configWidget.createControl(config);
        Label lblSelectOutputFolder = new Label(composite, 0);
        lblSelectOutputFolder.setText("Select Output Folder");
        this.txtSelectOutputFolder = new Text(composite, 2048);
        this.txtSelectOutputFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseOutputFolder = new Button(composite, 0);
        btnBrowseOutputFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SergeWizardPage1.this.settings.setOutputFolderPath(eOutputFolderChooser.open());
                SergeWizardPage1.this.txtSelectOutputFolder.setText(SergeWizardPage1.this.settings.getOutputFolderPath());
                SergeWizardPage1.this.configWidget.setSettings((EditRuleGenerationSettings)SergeWizardPage1.this.settings);
            }
        });
        btnBrowseOutputFolder.setText("Browse");
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SergeWizardPage1.this.validate();
            }
        };
        this.configWidget.getTxtDefaultConfig().addModifyListener(this.validationListener);
        this.configWidget.getTxtRefinedConfig().addModifyListener(this.validationListener);
        this.configWidget.getrBtnDefaultConfig().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SergeWizardPage1.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configWidget.getrBtnRefinedConfig().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SergeWizardPage1.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.txtSelectOutputFolder.addModifyListener(this.validationListener);
        this.setErrorMessage("Output Folder Path is missing");
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer cfr_ignored_0 = (IContainer)obj;
                } else {
                    ((IResource)obj).getParent();
                }
            }
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("serge")) {
            this.updateStatus("File extension must be \"serge\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return null;
    }

    public String getFileName() {
        return null;
    }
}

