/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.ui.wizards;

import java.io.IOException;
import javax.swing.JFrame;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.sidiff.common.emf.exceptions.EPackageNotFoundException;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.Serge;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;
import org.sidiff.editrule.generator.serge.ui.wizards.SergeWizardPage1;
import org.sidiff.editrule.generator.serge.ui.wizards.SergeWizardPage2;
import org.sidiff.editrule.generator.settings.EditRuleGenerationSettings;

public class SergeWizard
extends Wizard
implements INewWizard {
    private SergeWizardPage1 page;
    private SergeWizardPage2 page2;
    private ISelection selection;
    private SergeSettings settings;
    private JFrame frame;
    private Job job;
    private Boolean cancelable = false;

    public SergeWizard(IFile configFile) {
        this.settings = new SergeSettings(null, configFile.getLocation().toOSString(), true);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new SergeWizardPage1(this.selection, this.settings);
        this.page2 = new SergeWizardPage2(this.selection, this.settings);
        this.addPage((IWizardPage)this.page);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        this.job = new Job("EditRuleGeneration"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Generating Edit Rules", 100);
                Serge serge = new Serge();
                serge.init((EditRuleGenerationSettings)SergeWizard.this.settings, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    try {
                        serge.generateEditRules((IProgressMonitor)new SubProgressMonitor(monitor, 80));
                    }
                    catch (IOException | EPackageNotFoundException | OperationTypeNotImplementedException e1) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"An Error occurred during generation", (String)e1.getMessage());
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
        this.job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setPage(SergeWizardPage1 page) {
        this.page = page;
    }

    public void setPage2(SergeWizardPage2 page2) {
        this.page2 = page2;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public Boolean getCancelable() {
        return this.cancelable;
    }

    public void setCancelable(Boolean cancelable) {
        this.cancelable = cancelable;
    }
}

