/**
 */
package FaultTree.provider;

import FaultTree.util.FaultTreeAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FaultTreeItemProviderAdapterFactory extends FaultTreeAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FaultTreeItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.Hazard} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HazardItemProvider hazardItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.Hazard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHazardAdapter() {
		if (hazardItemProvider == null) {
			hazardItemProvider = new HazardItemProvider(this);
		}

		return hazardItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.IntermediateEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntermediateEventItemProvider intermediateEventItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.IntermediateEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntermediateEventAdapter() {
		if (intermediateEventItemProvider == null) {
			intermediateEventItemProvider = new IntermediateEventItemProvider(this);
		}

		return intermediateEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.FailureType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FailureTypeItemProvider failureTypeItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.FailureType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFailureTypeAdapter() {
		if (failureTypeItemProvider == null) {
			failureTypeItemProvider = new FailureTypeItemProvider(this);
		}

		return failureTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.FailureInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FailureInstanceItemProvider failureInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.FailureInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFailureInstanceAdapter() {
		if (failureInstanceItemProvider == null) {
			failureInstanceItemProvider = new FailureInstanceItemProvider(this);
		}

		return failureInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.BasicEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BasicEventItemProvider basicEventItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.BasicEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBasicEventAdapter() {
		if (basicEventItemProvider == null) {
			basicEventItemProvider = new BasicEventItemProvider(this);
		}

		return basicEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.UndevelopedEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UndevelopedEventItemProvider undevelopedEventItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.UndevelopedEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUndevelopedEventAdapter() {
		if (undevelopedEventItemProvider == null) {
			undevelopedEventItemProvider = new UndevelopedEventItemProvider(this);
		}

		return undevelopedEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.ErrorType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorTypeItemProvider errorTypeItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.ErrorType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorTypeAdapter() {
		if (errorTypeItemProvider == null) {
			errorTypeItemProvider = new ErrorTypeItemProvider(this);
		}

		return errorTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.ErrorInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorInstanceItemProvider errorInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.ErrorInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorInstanceAdapter() {
		if (errorInstanceItemProvider == null) {
			errorInstanceItemProvider = new ErrorInstanceItemProvider(this);
		}

		return errorInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.OR} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ORItemProvider orItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.OR}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createORAdapter() {
		if (orItemProvider == null) {
			orItemProvider = new ORItemProvider(this);
		}

		return orItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.AND} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ANDItemProvider andItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.AND}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createANDAdapter() {
		if (andItemProvider == null) {
			andItemProvider = new ANDItemProvider(this);
		}

		return andItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.XOR} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XORItemProvider xorItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.XOR}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXORAdapter() {
		if (xorItemProvider == null) {
			xorItemProvider = new XORItemProvider(this);
		}

		return xorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.PriorAND} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriorANDItemProvider priorANDItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.PriorAND}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPriorANDAdapter() {
		if (priorANDItemProvider == null) {
			priorANDItemProvider = new PriorANDItemProvider(this);
		}

		return priorANDItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.Inhibit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InhibitItemProvider inhibitItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.Inhibit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInhibitAdapter() {
		if (inhibitItemProvider == null) {
			inhibitItemProvider = new InhibitItemProvider(this);
		}

		return inhibitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FaultTree.Root} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RootItemProvider rootItemProvider;

	/**
	 * This creates an adapter for a {@link FaultTree.Root}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRootAdapter() {
		if (rootItemProvider == null) {
			rootItemProvider = new RootItemProvider(this);
		}

		return rootItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (hazardItemProvider != null) hazardItemProvider.dispose();
		if (intermediateEventItemProvider != null) intermediateEventItemProvider.dispose();
		if (failureTypeItemProvider != null) failureTypeItemProvider.dispose();
		if (failureInstanceItemProvider != null) failureInstanceItemProvider.dispose();
		if (basicEventItemProvider != null) basicEventItemProvider.dispose();
		if (undevelopedEventItemProvider != null) undevelopedEventItemProvider.dispose();
		if (errorTypeItemProvider != null) errorTypeItemProvider.dispose();
		if (errorInstanceItemProvider != null) errorInstanceItemProvider.dispose();
		if (orItemProvider != null) orItemProvider.dispose();
		if (andItemProvider != null) andItemProvider.dispose();
		if (xorItemProvider != null) xorItemProvider.dispose();
		if (priorANDItemProvider != null) priorANDItemProvider.dispose();
		if (inhibitItemProvider != null) inhibitItemProvider.dispose();
		if (rootItemProvider != null) rootItemProvider.dispose();
	}

}
