package ft;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.trace.TracePackage;
import org.sidiff.difference.technical.TechnicalDifferenceBuilder;

import FaultTree.FaultTreePackage;
import FaultTree.Root;

public class FtDifferenceBuilder extends TechnicalDifferenceBuilder {

	@Override
	protected Set<EClass> getUnconsideredNodeTypes() {
		Set<EClass> unconsideredNodeTypes = new HashSet<EClass>();

		unconsideredNodeTypes.add(TracePackage.eINSTANCE.getTrace());
		
		return unconsideredNodeTypes;
	}

	@Override
	protected Set<EReference> getUnconsideredEdgeTypes() {
		Set<EReference> unconsideredEdgeTypes = new HashSet<EReference>();

		return unconsideredEdgeTypes;
	}

	@Override
	protected Set<EAttribute> getUnconsideredAttributeTypes() {
		Set<EAttribute> unconsideredAttributeTypes = new HashSet<EAttribute>();

		return unconsideredAttributeTypes;
	}

	@Override
	protected String getObjectName(EObject obj) {
		if (obj instanceof Root) {
			return "[Root]";
		}

		EStructuralFeature attrName = obj.eClass().getEStructuralFeature("name");
		if (attrName != null) {
			return obj.eGet(attrName).toString();
		}

		EStructuralFeature attrId = obj.eClass().getEStructuralFeature("id");
		return obj.eGet(attrId).toString();		
	}

	@Override
	public String getDocumentType() {
		return FaultTreePackage.eNS_URI;
	}

}
