package org.sidiff.difference.ensure.evaluation.utils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.sidiff.difference.rulebase.EditRule;
import org.sidiff.difference.rulebase.extension.IRuleBase;
import org.sidiff.difference.rulebase.util.RuleBaseUtil;
import org.sidiff.difference.symmetric.AddObject;
import org.sidiff.difference.symmetric.AddReference;
import org.sidiff.difference.symmetric.Change;
import org.sidiff.difference.symmetric.RemoveObject;
import org.sidiff.difference.symmetric.RemoveReference;
import org.sidiff.difference.symmetric.SemanticChangeSet;
import org.sidiff.difference.symmetric.SymmetricDifference;

/**
 * Some utility functions to compute difference metrics.
 * 
 * @author cpietsch, kehrer
 */
public class EvaluationUtil {

	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getSERGe_SAFT_Changes(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = get_SERGe_SA_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		ruleBase = get_SERGe_FT_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getSERGe_SA_Changes(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = get_SERGe_SA_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getSERGe_FT_Changes(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = get_SERGe_FT_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getSERGe_Trace_Changes(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = get_SERGe_Trace_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getInterModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = getEnsureRulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	public static List<SemanticChangeSet> getConsistencyInterModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		List<SemanticChangeSet> allInter = getInterModelChanges(symmetricDifference);
		for (SemanticChangeSet changeSet : allInter) {
			if (changeSet.getName().startsWith("Ensure") || changeSet.getName().startsWith("Remove")){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	public static List<SemanticChangeSet> getCouplingInterModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		List<SemanticChangeSet> allInter = getInterModelChanges(symmetricDifference);
		for (SemanticChangeSet changeSet : allInter) {
			if (changeSet.getName().startsWith("Create") || changeSet.getName().startsWith("Connect")){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	public static List<SemanticChangeSet> getPropagationInterModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		List<SemanticChangeSet> allInter = getInterModelChanges(symmetricDifference);
		for (SemanticChangeSet changeSet : allInter) {
			if (changeSet.getName().startsWith("Propagate")){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	public static List<SemanticChangeSet> getDecouplingInterModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		List<SemanticChangeSet> allInter = getInterModelChanges(symmetricDifference);
		for (SemanticChangeSet changeSet : allInter) {
			if (changeSet.getName().startsWith("ClearTrace")){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<SemanticChangeSet> getIntraModelChanges(SymmetricDifference symmetricDifference){
		LinkedList<SemanticChangeSet> changes = new LinkedList<SemanticChangeSet>();
		
		IRuleBase ruleBase = getSA_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		ruleBase = getFT_Rulebase();
		for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
			if (contains(ruleBase, changeSet.getName())){
				changes.add(changeSet);
			}
		}
		
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<Change> getAddRemoveObjects(SymmetricDifference symmetricDifference){
		LinkedList<Change> changes = new LinkedList<Change>();
		
		for(Change change : symmetricDifference.getChanges()){
			if(change instanceof AddObject){
				changes.add(change);
			}
			if(change instanceof RemoveObject){
				changes.add(change);
			}
		}
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<Change> getAddRemoveReferences(SymmetricDifference symmetricDifference){
		LinkedList<Change> changes = new LinkedList<Change>();
		
		for(Change change : symmetricDifference.getChanges()){
			if(change instanceof AddReference){
				changes.add(change);
			}
			if(change instanceof RemoveReference){
				changes.add(change);
			}
		}
		return changes;
	}
	
	/**
	 * 
	 * @param symmetricDifference
	 * @return
	 */
	public static List<Change> getRemainingLowLevelChanges(SymmetricDifference symmetricDifference){
		LinkedList<Change> remainingLowLevelChanges = new LinkedList<Change>();

		for(Change change : symmetricDifference.getChanges()){
			boolean isRemainingLowLevelChange = true;
			for(SemanticChangeSet changeSet : symmetricDifference.getChangeSets()){
				if(changeSet.getChanges().contains(change)){
					isRemainingLowLevelChange = false;
				}
			}
			if(isRemainingLowLevelChange){
				remainingLowLevelChanges.add(change);
			}
		}
		return remainingLowLevelChanges;
	}
	
	public static String getDocTypeOfObjectResource(EObject eObject){
		EPackage pkg = eObject.eClass().getEPackage();
		while (pkg != null && pkg.getESuperPackage() != null) {
			pkg = pkg.getESuperPackage();
		}
		return pkg.getNsURI();
	}
	
	private static boolean contains(IRuleBase rb, String ruleName){
		for (EditRule er : rb.getActiveEditRules()) {
			if (er.getExecuteMainUnit().getModule().getName().equals(ruleName)){
				return true;
			}
		}
		
		return false;
	}
	
	private static IRuleBase getEnsureRulebase(){
		Set<String> docTypes = new HashSet<String>();
		docTypes.add("http://www.eclipse.org/emf/2011/Henshin/Trace");
		docTypes.add("http://SA/1.0");
		docTypes.add("http://FaultTree/1.0");
				
		for (IRuleBase rb : RuleBaseUtil.getAvailableRulebases(docTypes)) {
			if (rb.getName().trim().equals("Ensure")){
				return rb;
			}
		}
		
		return null;
	}
	
    private static IRuleBase getSA_Rulebase(){
		Set<String> docTypes = new HashSet<String>();
		docTypes.add("http://www.eclipse.org/emf/2011/Henshin/Trace");
		docTypes.add("http://SA/1.0");		
		
		for (IRuleBase rb : RuleBaseUtil.getAvailableRulebases(docTypes)) {
			if (rb.getName().equals("SA")){
				return rb;
			}
		}
		
		return null;
	}
    
    private static IRuleBase getFT_Rulebase(){
		Set<String> docTypes = new HashSet<String>();
		docTypes.add("http://www.eclipse.org/emf/2011/Henshin/Trace");		
		docTypes.add("http://FaultTree/1.0");
		
		for (IRuleBase rb : RuleBaseUtil.getAvailableRulebases(docTypes)) {
			if (rb.getName().trim().equals("FT")){
				return rb;
			}
		}
		
		return null;
	}
    
	private static IRuleBase get_SERGe_SA_Rulebase() {
		
		Set<IRuleBase> saRulebases = RuleBaseUtil.getAvailableRulebases("http://SA/1.0");
		for (IRuleBase iRuleBase : saRulebases) {
			if (iRuleBase.getName().equals("Software Architecture Atomic")){
				return iRuleBase;
			}
		}
		
		assert (false) : "SERGe SA Rulebase not found";
		return null;
	}
	
	private static IRuleBase get_SERGe_FT_Rulebase() {
		
		Set<IRuleBase> ftRulebases = RuleBaseUtil.getAvailableRulebases("http://FaultTree/1.0");
		for (IRuleBase iRuleBase : ftRulebases) {
			if (iRuleBase.getName().equals("Fault Tree Atomic")){
				return iRuleBase;
			}
		}
		
		assert (false) : "SERGe FT Rulebase not found";
		return null;
	}
	
	private static IRuleBase get_SERGe_Trace_Rulebase() {
		
		Set<String> documentTypes = new HashSet<String>();
		documentTypes.add("http://SA/1.0");
		documentTypes.add("http://FaultTree/1.0");
		documentTypes.add("http://www.eclipse.org/emf/2011/Henshin/Trace");
		Set<IRuleBase> traceRulebases = RuleBaseUtil.getAvailableRulebases(documentTypes);
		for (IRuleBase iRuleBase : traceRulebases) {
			if (iRuleBase.getName().equals("Trace Atomic")){
				return iRuleBase;
			}
		}
		
		assert (false) : "SERGe Trace Rulebase not found";
		return null;
	}
}
