package saft.transformations.manual.validation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/**
 * Data class representing a PPU evolution scenario.
 * 
 * @author kehrer
 */
public class Scenario {

	String name;

	// The descriptors
	String saOrigin;
	String saChanged;

	String ft1Origin;
	String ft1Changed;

	String ft2Origin;
	String ft2Changed;

	// The resource sets
	private ResourceSet resSetOrigin = new ResourceSetImpl();
	private ResourceSet resSetChanged = new ResourceSetImpl();

	public void init() {
		getResSaOrigin();
		getResSaChanged();
		getResFt1Origin();
		getResFt1Changed();
		getResFt2Origin();
		getResFt2Changed();
	}

	public Resource getResSaOrigin() {
		return resSetOrigin.getResource(URI.createPlatformResourceURI(saOrigin, false), true);
	}

	public Resource getResSaChanged() {
		return resSetChanged.getResource(URI.createPlatformResourceURI(saChanged, false), true);
	}

	public Resource getResFt1Origin() {
		return resSetOrigin.getResource(URI.createPlatformResourceURI(ft1Origin, false), true);
	}

	public Resource getResFt1Changed() {
		return resSetChanged.getResource(URI.createPlatformResourceURI(ft1Changed, false), true);
	}

	public Resource getResFt2Origin() {
		return resSetOrigin.getResource(URI.createPlatformResourceURI(ft2Origin, false), true);
	}

	public Resource getResFt2Changed() {
		return resSetChanged.getResource(URI.createPlatformResourceURI(ft2Changed, false), true);
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("==== Scenario =====\n");
		buffer.append("name: " + name + "\n");
		buffer.append("saOrigin: " + saOrigin + "\n");
		buffer.append("saChanged: " + saChanged + "\n");
		buffer.append("ft1Origin: " + ft1Origin + "\n");
		buffer.append("ft1Changed: " + ft1Changed + "\n");
		buffer.append("ft2Origin: " + ft2Origin + "\n");
		buffer.append("ft2Changed: " + ft2Changed + "\n");

		return buffer.toString();
	}

}
