package saft.transformations.manual.validation;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.henshin.trace.TracePackage;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.sidiff.difference.evaluation.EvaluationRun;

import FaultTree.FaultTreePackage;
import SA.SAPackage;

/**
 * Measurements on created diffs.
 * 
 * @author kehrer
 */
public class Measures implements IApplication {

	private static final String resFolderPath = "saft.transformations.manual.validation.results/results";
	
	@SuppressWarnings("unused")
	private static BundleContext context = null;

	public static void start(BundleContext context) {
		Measures.context = context;

		// Init meta-models
		SAPackage.eINSTANCE.eClass();
		FaultTreePackage.eINSTANCE.eClass();
		TracePackage.eINSTANCE.eClass();
	}

	public static void stop(BundleContext context) {
		Measures.context = null;
	}

	@Override
	public Object start(IApplicationContext context) throws Exception {
		IPath wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
		String resFolder = wsPath.append(resFolderPath).toOSString();
		
		EvaluationRun.run(resFolder);
		
		return IApplication.EXIT_OK;
	}

	@Override
	public void stop() {

	}
}
