package saft.transformations.manual.validation;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.henshin.trace.TracePackage;
import org.sidiff.common.emf.exceptions.InvalidModelException;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.difference.lifting.facade.LiftingFacade;
import org.sidiff.difference.lifting.settings.LiftingSettings;
import org.sidiff.difference.rulebase.extension.IRuleBase;
import org.sidiff.difference.rulebase.util.RuleBaseUtil;
import org.sidiff.difference.symmetric.SymmetricDifference;
import org.silift.common.util.emf.Scope;
import org.silift.common.util.exceptions.NoCorrespondencesException;

import FaultTree.FaultTreePackage;
import SA.SAPackage;

/**
 * Running SiLift with rules generated by SERGe.
 * 
 * @author kehrer
 */
public class DiffSERGe extends AbstractDiffCreator {

	@Override
	protected void diff(Scenario scenario) {
		diffAll_SERGe(scenario);
	}

	private void diffAll_SERGe(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE, "================================= diff ALL SERGe ===================================");

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getIncrementalMatcher(scenario));
		settings.setRuleBases(get_SERGe_RuleBases());
		settings.setScope(Scope.RESOURCE_SET);
		settings.setTechBuilder(getIncrementalBuilder(scenario));

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade.liftMeUp(scenario.getResSaOrigin(), scenario.getResSaChanged(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_SERGe");
	}
	
	private Set<IRuleBase> get_SERGe_RuleBases() {
		Set<IRuleBase> rbs = new HashSet<IRuleBase>();
		
		// SA atomic
		Set<IRuleBase> saRulebases = RuleBaseUtil.getAvailableRulebases(SAPackage.eNS_URI);
		for (IRuleBase iRuleBase : saRulebases) {
			if (iRuleBase.getName().equals("Software Architecture Atomic")){
				rbs.add(iRuleBase);
			}
		}
		
		// FT atomic
		Set<IRuleBase> ftRulebases = RuleBaseUtil.getAvailableRulebases(FaultTreePackage.eNS_URI);
		for (IRuleBase iRuleBase : ftRulebases) {
			if (iRuleBase.getName().equals("Fault Tree Atomic")){
				rbs.add(iRuleBase);
			}
		}
		
		// Trace atomic
		Set<String> documentTypes = new HashSet<String>();
		documentTypes.add(SAPackage.eNS_URI);
		documentTypes.add(FaultTreePackage.eNS_URI);
		documentTypes.add(TracePackage.eNS_URI);
		Set<IRuleBase> traceRulebases = RuleBaseUtil.getAvailableRulebases(documentTypes);
		for (IRuleBase iRuleBase : traceRulebases) {
			if (iRuleBase.getName().equals("Trace Atomic")){
				rbs.add(iRuleBase);
			}
		}
		
		return rbs;
	}
}
