package saft.transformations.manual.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.henshin.trace.TracePackage;
import org.sidiff.common.emf.exceptions.InvalidModelException;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.difference.lifting.facade.LiftingFacade;
import org.sidiff.difference.lifting.settings.LiftingSettings;
import org.sidiff.difference.rulebase.EditRule;
import org.sidiff.difference.rulebase.extension.IRuleBase;
import org.sidiff.difference.rulebase.util.RuleBaseUtil;
import org.sidiff.difference.symmetric.SymmetricDifference;
import org.silift.common.util.emf.Scope;
import org.silift.common.util.exceptions.NoCorrespondencesException;

import FaultTree.FaultTreePackage;
import SA.SAPackage;

/**
 * Running SiLift to search for pattern occurrences.
 * 
 * @author kehrer
 */
public class DiffPattern extends AbstractDiffCreator {

	@Override
	protected void diff(Scenario scenario) {
		diffPattern(scenario);
	}
	
	private void diffPattern(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE,
				"================================= diff Pattern ===================================");

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getIncrementalMatcher(scenario));
		settings.setRuleBases(get_Pattern_RuleBases());
		settings.setScope(Scope.RESOURCE_SET);
		settings.setTechBuilder(getIncrementalBuilder(scenario));
		settings.setRrSorter(getSAFTRecognitionRuleSorter());

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade.liftMeUp(scenario.getResSaOrigin(), scenario.getResSaChanged(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_ALL_");
	}

	private Set<IRuleBase> get_Pattern_RuleBases() {
		Set<String> documentTypes = new HashSet<String>();
		documentTypes.add(SAPackage.eNS_URI);
		documentTypes.add(FaultTreePackage.eNS_URI);
		documentTypes.add(TracePackage.eNS_URI);

		Set<IRuleBase> rbs = RuleBaseUtil.getAvailableRulebases(documentTypes);
		for (Iterator<IRuleBase> iterator = rbs.iterator(); iterator.hasNext();) {
			IRuleBase iRuleBase = (IRuleBase) iterator.next();
			if (!iRuleBase.getName().equals("Patterns")) {
				iterator.remove();
			}
		}

		System.out.println("-----------------------------------------------------");
		List<String> names = new ArrayList<String>();
		for (EditRule er : rbs.iterator().next().getActiveEditRules()) {
			names.add(er.getExecuteModule().getName());
		}
		Collections.sort(names);
		for (String string : names) {
			System.out.println(string);
		}
		System.out.println("-----------------------------------------------------");
				
		return rbs;
	}
}
