package saft.transformations.manual.validation;

import java.io.File;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.trace.Trace;
import org.sidiff.common.emf.exceptions.InvalidModelException;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.difference.lifting.facade.LiftingFacade;
import org.sidiff.difference.lifting.settings.LiftingSettings;
import org.sidiff.difference.symmetric.SymmetricDifference;
import org.silift.common.util.emf.Scope;
import org.silift.common.util.exceptions.NoCorrespondencesException;

import FaultTree.FaultTreePackage;

/**
 * Running SiLift on a single model type (SA or FT) only. Use only intra rules.
 * 
 * @author kehrer
 */
public class DiffIntra extends AbstractDiffCreator {

	@Override
	protected void diff(Scenario scenario) {
		diffSA(scenario);
		diffFT1(scenario);
		diffFT2(scenario);
	}

	private void diffSA(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE, "================================= diff SA ===================================");

		// SymmetricDifference liftedDifference =
		// LiftingFacade.deriveTechnicalDifferences(scenario.getResSaOrigin(),
		// scenario.getResSaChanged(), Scope.RESOURCE, getSA_Matcher(scenario),
		// getSA_Builder(scenario));

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getSA_Matcher(scenario));
		settings.setRuleBases(get_SA_RuleBases());
		settings.setScope(Scope.RESOURCE);
		settings.setTechBuilder(getSA_Builder(scenario));

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade.liftMeUp(scenario.getResSaOrigin(), scenario.getResSaChanged(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_SA_");
	}

	private void diffFT1(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE, "================================= diff FT1 ===================================");

		cleanModel(FaultTreePackage.eNS_URI, scenario.getResFt1Origin());
		cleanModel(FaultTreePackage.eNS_URI, scenario.getResFt1Changed());

		// SymmetricDifference liftedDifference =
		// LiftingFacade.deriveTechnicalDifferences(scenario.getResFt1Origin(),
		// scenario.getResFt1Changed(), Scope.RESOURCE, getFT_Matcher(scenario),
		// getFT_Builder(scenario));

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getFT_Matcher(scenario));
		settings.setRuleBases(get_FT_RuleBases());
		settings.setScope(Scope.RESOURCE);
		settings.setTechBuilder(getFT_Builder(scenario));

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade
					.liftMeUp(scenario.getResFt1Origin(), scenario.getResFt1Changed(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_FT1_");
	}

	private void diffFT2(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE, "================================= diff FT2 ===================================");

		// delete trace links because we do not care about them here
		cleanModel(FaultTreePackage.eNS_URI, scenario.getResFt2Origin());
		cleanModel(FaultTreePackage.eNS_URI, scenario.getResFt2Changed());

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getFT_Matcher(scenario));
		settings.setRuleBases(get_FT_RuleBases());
		settings.setScope(Scope.RESOURCE);
		settings.setTechBuilder(getFT_Builder(scenario));

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade
					.liftMeUp(scenario.getResFt2Origin(), scenario.getResFt2Changed(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_FT2_");
	}

	private void cleanModel(String documentType, Resource model) {
		// We remove trace links for the pure FT comparison
		for (Iterator<EObject> iterator = model.getAllContents(); iterator.hasNext();) {
			EObject object = iterator.next();
			if (object instanceof Trace) {
				iterator.remove();
			}
		}
	}
}
