package saft.transformations.manual.validation;

import java.io.File;

import org.sidiff.common.emf.exceptions.InvalidModelException;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.difference.lifting.facade.LiftingFacade;
import org.sidiff.difference.lifting.settings.LiftingSettings;
import org.sidiff.difference.symmetric.SymmetricDifference;
import org.silift.common.util.emf.Scope;
import org.silift.common.util.exceptions.NoCorrespondencesException;

public class DiffInterIntra extends AbstractDiffCreator {

	@Override
	protected void diff(Scenario scenario) {
		diffAll(scenario);
	}

	private void diffAll(Scenario scenario) {
		LogUtil.log(LogEvent.NOTICE, "================================= diff ALL ===================================");

		LiftingSettings settings = new LiftingSettings();
		settings.setMatcher(getIncrementalMatcher(scenario));
		settings.setRuleBases(get_ALL_RuleBases());
		settings.setScope(Scope.RESOURCE_SET);
		settings.setTechBuilder(getIncrementalBuilder(scenario));

		SymmetricDifference liftedDifference = null;
		try {
			liftedDifference = LiftingFacade.liftMeUp(scenario.getResSaOrigin(), scenario.getResSaChanged(), settings);
		} catch (InvalidModelException e) {
			e.printStackTrace();
		} catch (NoCorrespondencesException e) {
			e.printStackTrace();
		}

		String out = outputFolder + File.separator + scenario.name;
		LiftingFacade.serializeDifference(liftedDifference, out, scenario.name + "_ALL_");
	}

}
