package org.sidiff.difference.evaluation;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.resource.Resource;
import org.sidiff.difference.asymmetric.facade.util.Difference;
import org.sidiff.difference.symmetric.SymmetricDifference;

/**
 * 
 * @author kehrer
 *
 */
public class TestCase {

	private List<Difference> difference;
	private List<AbstractTestCaseEntry> entries;
	
	public TestCase(List<Difference> difference){
		this.difference = difference;
		this.entries = new ArrayList<AbstractTestCaseEntry>();
	}
	
	public String getName() {
		
		SymmetricDifference symmetricDifference = difference.get(0).getSymmetric();
		
		Resource modelA = symmetricDifference.getModelA();
		Resource modelB = symmetricDifference.getModelB();
		
		String nA = modelA.getURI().lastSegment();
		nA = nA.substring(0,nA.lastIndexOf("."));
		
		String nB = modelB.getURI().lastSegment();
		nB = nB.substring(0,nB.lastIndexOf("."));
		
		return nA + "->" + nB;
	}

	public List<AbstractTestCaseEntry> getEntries() {
		return entries;
	}
	
}
