//
// DateTimeFormat.h
//
// $Id: //poco/svn/Foundation/include/Poco/DateTimeFormat.h#2 $
//
// Library: Foundation
// Package: DateTime
// Module:  DateTimeFormat
//
// Definition of the DateTimeFormat class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_DateTimeFormat_INCLUDED
#define Foundation_DateTimeFormat_INCLUDED


#include "Poco/Foundation.h"


namespace Poco {


class Foundation_API DateTimeFormat
	/// Definition of date/time formats and various
	/// constants used by DateTimeFormatter and DateTimeParser.
{
public:
	// predefined date formats
	static const std::string ISO8601_FORMAT;
		/// The date/time format defined in the ISO 8601 standard.
		///
		/// Examples: 
		///   2005-01-01T12:00:00+01:00
		///   2005-01-01T11:00:00Z
	
	static const std::string RFC822_FORMAT;
		/// The date/time format defined in RFC 822 (obsoleted by RFC 1123).
		///
		/// Examples: 
		///   Sat, 1 Jan 05 12:00:00 +0100
		///   Sat, 1 Jan 05 11:00:00 GMT

	static const std::string RFC1123_FORMAT;
		/// The date/time format defined in RFC 1123 (obsoletes RFC 822).
		///
		/// Examples: 
		///   Sat, 1 Jan 2005 12:00:00 +0100
		///   Sat, 1 Jan 2005 11:00:00 GMT

	static const std::string HTTP_FORMAT;
		/// The date/time format defined in the HTTP specification (RFC 2616),
		/// which is basically a variant of RFC 1036 with a zero-padded day field.
		///
		/// Examples: 
		///   Sat, 01 Jan 2005 12:00:00 +0100
		///   Sat, 01 Jan 2005 11:00:00 GMT

	static const std::string RFC850_FORMAT;
		/// The date/time format defined in RFC 850 (obsoleted by RFC 1036).
		///
		/// Examples: 
		///   Saturday, 1-Jan-05 12:00:00 +0100
		///   Saturday, 1-Jan-05 11:00:00 GMT

	static const std::string RFC1036_FORMAT;
		/// The date/time format defined in RFC 1036 (obsoletes RFC 850).
		///
		/// Examples: 
		///   Saturday, 1 Jan 05 12:00:00 +0100
		///   Saturday, 1 Jan 05 11:00:00 GMT

	static const std::string ASCTIME_FORMAT;
		/// The date/time format produced by the ANSI C asctime() function.
		///
		/// Example: 
		///   Sat Jan  1 12:00:00 2005

	static const std::string SORTABLE_FORMAT;
		/// A simple, sortable date/time format.
		///
		/// Example:
		///   2005-01-01 12:00:00


	// names used by formatter and parser
	static const std::string WEEKDAY_NAMES[7];
		/// English names of week days (Sunday, Monday, Tuesday, ...).
		
	static const std::string MONTH_NAMES[12];
		/// English names of months (January, February, ...).	
};


} // namespace Poco


#endif // Foundation_DateTimeFormat_INCLUDED
