//
// BulkExtraction.h
//
// $Id: //poco/Main/Data/include/Poco/Data/Bulk.h#9 $
//
// Library: Data
// Package: DataCore
// Module:  Bulk
//
// Definition of the BulkExtraction class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_Bulk_INCLUDED
#define Data_Bulk_INCLUDED


#include "Poco/Void.h"
#include "Poco/Data/Limit.h"


namespace Poco {
namespace Data {


class Data_API Bulk
{
public:
	Bulk(const Limit& limit);
		/// Creates the Bulk.

	Bulk(Poco::UInt32 value);
		/// Creates the Bulk.

	~Bulk();
		/// Destroys the bulk.

	const Limit& limit() const;
		/// Returns the limit asociated with this bulk object.

	Poco::UInt32 size() const;
		/// Returns the value of the limit asociated with 
		/// this bulk object.
	
private:
	Bulk();

	Limit _limit;
};


///
/// inlines
///
inline const Limit& Bulk::limit() const 
{ 
	return _limit; 
}


inline Poco::UInt32 Bulk::size() const 
{ 
	return _limit.value(); 
}


namespace Keywords {


inline Bulk bulk(const Limit& limit = Limit(Limit::LIMIT_UNLIMITED, false, false))
	/// Convenience function for creation of bulk.
{
	return Bulk(limit);
}


inline void bulk(Void)
	/// Dummy bulk function. Used for bulk binding creation
	/// (see BulkBinding) and bulk extraction signalling to Statement.
{
}


} // namespace Keywords


typedef void (*BulkFnType)(Void);


} } // namespace Poco::Data


#endif // Data_Bulk_INCLUDED
