//
// AbstractPreparator.h
//
// $Id: //poco/Main/Data/include/Poco/Data/AbstractPreparator.h#5 $
//
// Library: Data
// Package: DataCore
// Module:  AbstractPreparator
//
// Definition of the AbstractPreparator class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_AbstractPreparator_INCLUDED
#define Data_AbstractPreparator_INCLUDED


#include "Poco/Data/Data.h"
#include "Poco/RefCountedObject.h"
#include "Poco/Data/LOB.h"
#include <vector>
#include <deque>
#include <list>
#include <cstddef>


namespace Poco {


class DateTime;
class Any;

namespace Dynamic {
class Var;
}


namespace Data {


class Date;
class Time;


class Data_API AbstractPreparator: public Poco::RefCountedObject
	/// Interface used for database preparation where we first have to register all data types (and memory output locations)
	/// before extracting data, i.e. extract works as two-pase extract: first we call prepare once, then extract n-times.
	/// There are cases (bulk operations using std::vector storage) when extract is called only once.
	/// The value passed to a prepare() call is not be used by the prepare, serving only as an indication of the data type
	/// being prepared. 
	/// Implementing this interface is not mandatory for a connector. Connectors that only extract data after SQL execution 
	/// (e.g. SQLite) do not need this functionality at all.
{
public:
	AbstractPreparator(Poco::UInt32 length = 1u);
		/// Creates the AbstractPreparator.

	virtual ~AbstractPreparator();
		/// Destroys the AbstractPreparator.

	virtual void prepare(std::size_t pos, Poco::Int8&) = 0;
		/// Preparations an Int8.

	virtual void prepare(std::size_t pos, std::vector<Poco::Int8>& val);
		/// Preparations an Int8 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::Int8>& val);
		/// Preparations an Int8 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::Int8>& val);
		/// Preparations an Int8 list.

	virtual void prepare(std::size_t pos, Poco::UInt8&) = 0;
		/// Preparations an UInt8.

	virtual void prepare(std::size_t pos, std::vector<Poco::UInt8>& val);
		/// Preparations an UInt8 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::UInt8>& val);
		/// Preparations an UInt8 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::UInt8>& val);
		/// Preparations an UInt8 list.

	virtual void prepare(std::size_t pos, Poco::Int16&) = 0;
		/// Preparations an Int16.

	virtual void prepare(std::size_t pos, std::vector<Poco::Int16>& val);
		/// Preparations an Int16 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::Int16>& val);
		/// Preparations an Int16 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::Int16>& val);
		/// Preparations an Int16 list.

	virtual void prepare(std::size_t pos, Poco::UInt16&) = 0;
		/// Preparations an UInt16.

	virtual void prepare(std::size_t pos, std::vector<Poco::UInt16>& val);
		/// Preparations an UInt16 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::UInt16>& val);
		/// Preparations an UInt16 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::UInt16>& val);
		/// Preparations an UInt16 list.

	virtual void prepare(std::size_t pos, Poco::Int32&) = 0;
		/// Preparations an Int32.

	virtual void prepare(std::size_t pos, std::vector<Poco::Int32>& val);
		/// Preparations an Int32 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::Int32>& val);
		/// Preparations an Int32 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::Int32>& val);
		/// Preparations an Int32 list.

	virtual void prepare(std::size_t pos, Poco::UInt32&) = 0;
		/// Preparations an UInt32.

	virtual void prepare(std::size_t pos, std::vector<Poco::UInt32>& val);
		/// Preparations an UInt32 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::UInt32>& val);
		/// Preparations an UInt32 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::UInt32>& val);
		/// Preparations an UInt32 list.

	virtual void prepare(std::size_t pos, Poco::Int64&) = 0;
		/// Preparations an Int64.

	virtual void prepare(std::size_t pos, std::vector<Poco::Int64>& val);
		/// Preparations an Int64 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::Int64>& val);
		/// Preparations an Int64 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::Int64>& val);
		/// Preparations an Int64 list.

	virtual void prepare(std::size_t pos, Poco::UInt64&) = 0;
		/// Preparations an UInt64.

	virtual void prepare(std::size_t pos, std::vector<Poco::UInt64>& val);
		/// Preparations an UInt64 vector.

	virtual void prepare(std::size_t pos, std::deque<Poco::UInt64>& val);
		/// Preparations an UInt64 deque.

	virtual void prepare(std::size_t pos, std::list<Poco::UInt64>& val);
		/// Preparations an UInt64 list.

#ifndef POCO_LONG_IS_64_BIT
	virtual void prepare(std::size_t pos, long&) = 0;
		/// Preparations a long.

	virtual void prepare(std::size_t pos, std::vector<long>& val);
		/// Preparations a long vector.

	virtual void prepare(std::size_t pos, std::deque<long>& val);
		/// Preparations a long deque.

	virtual void prepare(std::size_t pos, std::list<long>& val);
		/// Preparations a long list.
#endif

	virtual void prepare(std::size_t pos, bool&) = 0;
		/// Preparations a boolean.

	virtual void prepare(std::size_t pos, std::vector<bool>& val);
		/// Preparations a boolean vector.

	virtual void prepare(std::size_t pos, std::deque<bool>& val);
		/// Preparations a boolean deque.

	virtual void prepare(std::size_t pos, std::list<bool>& val);
		/// Preparations a boolean list.

	virtual void prepare(std::size_t pos, float&) = 0;
		/// Preparations a float.

	virtual void prepare(std::size_t pos, std::vector<float>& val);
		/// Preparations a float vector.

	virtual void prepare(std::size_t pos, std::deque<float>& val);
		/// Preparations a float deque.

	virtual void prepare(std::size_t pos, std::list<float>& val);
		/// Preparations a float list.

	virtual void prepare(std::size_t pos, double&) = 0;
		/// Preparations a double.

	virtual void prepare(std::size_t pos, std::vector<double>& val);
		/// Preparations a double vector.

	virtual void prepare(std::size_t pos, std::deque<double>& val);
		/// Preparations a double deque.

	virtual void prepare(std::size_t pos, std::list<double>& val);
		/// Preparations a double list.

	virtual void prepare(std::size_t pos, char&) = 0;
		/// Preparations a single character.

	virtual void prepare(std::size_t pos, std::vector<char>& val);
		/// Preparations a character vector.

	virtual void prepare(std::size_t pos, std::deque<char>& val);
		/// Preparations a character deque.

	virtual void prepare(std::size_t pos, std::list<char>& val);
		/// Preparations a character list.

	virtual void prepare(std::size_t pos, const std::string&) = 0;
		/// Preparations a string.

	virtual void prepare(std::size_t pos, const std::vector<std::string>& val);
		/// Preparations a string vector.

	virtual void prepare(std::size_t pos, const std::deque<std::string>& val);
		/// Preparations a string deque.

	virtual void prepare(std::size_t pos, const std::list<std::string>& val);
		/// Preparations a string list.

	virtual void prepare(std::size_t pos, const BLOB&) = 0;
		/// Preparations a BLOB.

	virtual void prepare(std::size_t pos, const CLOB&) = 0;
		/// Preparations a CLOB.

	virtual void prepare(std::size_t pos, const std::vector<BLOB>& val);
		/// Preparations a BLOB vector.

	virtual void prepare(std::size_t pos, const std::deque<BLOB>& val);
		/// Preparations a BLOB deque.

	virtual void prepare(std::size_t pos, const std::list<BLOB>& val);
		/// Preparations a BLOB list.

	virtual void prepare(std::size_t pos, const std::vector<CLOB>& val);
		/// Preparations a CLOB vector.

	virtual void prepare(std::size_t pos, const std::deque<CLOB>& val);
		/// Preparations a CLOB deque.

	virtual void prepare(std::size_t pos, const std::list<CLOB>& val);
		/// Preparations a CLOB list.

	virtual void prepare(std::size_t pos, const DateTime&) = 0;
		/// Preparations a DateTime.

	virtual void prepare(std::size_t pos, const std::vector<DateTime>& val);
		/// Preparations a DateTime vector.

	virtual void prepare(std::size_t pos, const std::deque<DateTime>& val);
		/// Preparations a DateTime deque.

	virtual void prepare(std::size_t pos, const std::list<DateTime>& val);
		/// Preparations a DateTime list.

	virtual void prepare(std::size_t pos, const Date&) = 0;
		/// Preparations a Date.

	virtual void prepare(std::size_t pos, const std::vector<Date>& val);
		/// Preparations a Date vector.

	virtual void prepare(std::size_t pos, const std::deque<Date>& val);
		/// Preparations a Date deque.

	virtual void prepare(std::size_t pos, const std::list<Date>& val);
		/// Preparations a Date list.

	virtual void prepare(std::size_t pos, const Time&) = 0;
		/// Preparations a Time.

	virtual void prepare(std::size_t pos, const std::vector<Time>& val);
		/// Preparations a Time vector.

	virtual void prepare(std::size_t pos, const std::deque<Time>& val);
		/// Preparations a Time deque.
	
	virtual void prepare(std::size_t pos, const std::list<Time>& val);
		/// Preparations a Time list.

	virtual void prepare(std::size_t pos, const Any&) = 0;
		/// Preparations an Any.

	virtual void prepare(std::size_t pos, const std::vector<Any>& val);
		/// Preparations an Any vector.

	virtual void prepare(std::size_t pos, const std::deque<Any>& val);
		/// Preparations an Any deque.

	virtual void prepare(std::size_t pos, const std::list<Any>& val);
		/// Preparations an Any list.

	virtual void prepare(std::size_t pos, const Poco::Dynamic::Var&) = 0;
		/// Preparations a Var.

	virtual void prepare(std::size_t pos, const std::vector<Poco::Dynamic::Var>& val);
		/// Preparations a Var vector.

	virtual void prepare(std::size_t pos, const std::deque<Poco::Dynamic::Var>& val);
		/// Preparations a Var deque.

	virtual void prepare(std::size_t pos, const std::list<Poco::Dynamic::Var>& val);
		/// Preparations a Var list.

	void setLength(Poco::UInt32 length);
		/// Sets the length of prepared data.
		/// Needed only for data lengths greater than 1 (i.e. for
		/// bulk operations).

	Poco::UInt32 getLength() const;
		/// Returns the length of prepared data. Defaults to 1.
		/// The length is greater than one for bulk operations.

	void setBulk(bool bulkPrep = true);
		/// Sets bulk operation flag (always false at object creation time)

	bool isBulk() const;
		/// Returns bulk operation flag.

private:
	Poco::UInt32 _length;
	bool         _bulk;
};


///
/// inlines
///
inline void AbstractPreparator::setLength(Poco::UInt32 length)
{
	_length = length;
}


inline Poco::UInt32 AbstractPreparator::getLength() const
{
	return _length;
}


inline void AbstractPreparator::setBulk(bool bulkPrep)
{
	_bulk = bulkPrep;
}


inline bool AbstractPreparator::isBulk() const
{
	return _bulk;
}


} } // namespace Poco::Data


#endif // Data_AbstractPreparator_INCLUDED
