/**
 * @file TestVersion.cpp
 * @date Jul 7, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class Version
 */

#include "../Main/Globals.h"
#include <odemx/util/Version.h>

#include <sstream>

/// @cond DOXYGEN_SKIP
SUITE( Util )
{
/// @endcond

	/**
	 * @test odemx::Version
	 *
	 * This test checks if the return value of \c Version::getString()
	 * corresponds to the values \c Version::getMajor() and
	 * \c Version::getMinor().
	 */
	TEST( VersionGetString )
	{
		std::ostringstream versionString;
		versionString << odemx::Version::getMajor()
				<< '.' << odemx::Version::getMinor();

		CHECK_EQUAL( versionString.str(), odemx::Version::getString() );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
