/**
 * @file TestStringConversion.cpp
 * @date Apr 28, 2010
 * @author ron
 *
 * @brief
 */

#include "../Main/Globals.h"
#include <odemx/util/StringConversion.h>

SUITE( Util )
{
	struct Pair
	{
		int x, y;
	};

	std::ostream& operator<<( std::ostream& os, const Pair& p )
	{
		os << '(' << p.x << ',' << p.y << ')';
		return os;
	}

	TEST( FunctionToString )
	{
		Pair p = { 10, 20 };
		std::string s = toString( p );
		CHECK_EQUAL( "(10,20)", s );
	}
}
