/**
 * @file TestDiscreteDist.cpp
 * @date Aug 9, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class DiscreteDist
 */

#include "TestRandom.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Random )
{
/// @endcond

	/**
	 * @struct DiscreteDistFixture
	 * @brief Helper struct providing set-up/tear-down of DiscreteDist tests
	 *
	 * @copydetails EventFixture
	 */
	struct DiscreteDistFixture
	{
		SuiteBase::SimulationTest sim;
		DiscreteDistTest dist;

		DiscreteDistFixture()
		:	sim( "DiscreteDistTestSim" ),
			dist( sim, "DiscreteDistTest" )
			{}
	};

	/**
	 * @test odemx::DiscreteDist construction
	 *
	 * Expected function call effects:
	 * @li dist context (simulation) is set correctly
	 * @li label is set correctly
	 */
	TEST_FIXTURE( DiscreteDistFixture, ConstructionDestruction )
	{
		data::Label l = "DiscreteDistTestUserSimConstruction";
		DiscreteDistTest dist( sim, l );
		CHECK_EQUAL( l, dist.getLabel() );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
