/**
 * @file TestContinuousConst.cpp
 * @date Aug 9, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class ContinuousConst
 */

#include "TestRandom.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Random )
{
/// @endcond

	/**
	 * @struct ContinuousConstFixture
	 * @brief Helper struct providing set-up/tear-down of ContinuousConst tests
	 *
	 * @copydetails EventFixture
	 */
	struct ContinuousConstFixture
	{
		SuiteBase::SimulationTest sim;
		TestLogConsumer::Ptr log;
		double constValue;
		ContinuousConst continuousConst;
		data::TypeInfo type;

		ContinuousConstFixture()
		:	sim( "ContinuousConstTestSim" ),
		 	log( TestLogConsumer::create() ),
			constValue( 1.23456789 ),
			continuousConst( sim, "ContinuousConstTest", constValue ),
			type( typeid(ContinuousConst) )
			{
				sim.addConsumer( log );
			}
	};

	/**
	 * @test odemx::ContinuousConst construction
	 *
	 * Expected function call effects:
	 * @li label is set
	 * @li dist context (simulation) is set
	 * @li const value is set
	 */
	TEST_FIXTURE( ContinuousConstFixture, ConstructionDestruction )
	{
		data::Label l = "ContinuousConstTestUserSimConstruction";
		{
			ContinuousConst continuousConst( sim, l, constValue );
			CHECK( log->getTraceRecord( "create", type ) );
			CHECK( log->getStatisticsRecord( "parameter", "seed", type ) );
			CHECK( log->getStatisticsRecord( "parameter", "value", type ) );
			CHECK_EQUAL( l, continuousConst.getLabel() );
			CHECK_EQUAL( constValue, continuousConst.getValue() );
		}
		CHECK( log->getTraceRecord( "destroy", type ) );
	}

	/**
	 * @test odemx::ContinuousConst::sample()
	 *
	 * Expected function call effects:
	 * @li samples equal the const value
	 */
	TEST_FIXTURE( ContinuousConstFixture, Sample )
	{
		CHECK_EQUAL( continuousConst.getValue(), continuousConst.sample() );
		CHECK( log->getTraceRecord( "sample", type ) );
		CHECK( log->getStatisticsRecord( "count", "uses", type ) );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
