/**
 * @file TestOStreamReport.cpp
 * @date May 3, 2010
 * @author ron
 *
 * @brief
 */

#include "../TestData.h"
#include "../../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Data )
{
/// @endcond

	/**
	 * @struct OStreamReportFixture
	 * @brief Helper struct providing set-up/tear-down of OStreamReport tests
	 *
	 * @copydetails EventFixture
	 */
	struct OStreamReportFixture
	{
		SuiteBase::SimulationTest sim;
		std::ostringstream stream;
		OStreamReport reporter;
		odemx::statistics::Count count;

		OStreamReportFixture()
		:	sim( "OStreamReportTestSim" ),
			stream(),
			reporter( stream ),
			count( sim, "OStreamReportTestCount" )
			{}
	};

	/**
	 * @test odemx::XmlReport file output
	 *
	 * Expected function call effects:
	 * @li the file contains the expected xml output
	 */
	TEST_FIXTURE( OStreamReportFixture, GenerateReport )
	{
		unsigned int inc = 13;
		count.reset( base::SimTime(23) ); // non-0 reset time
		count.update( inc ); // two updates
		count.update( inc ); // result in value inc * 2

		reporter.addReportProducer( count );
		reporter.generateReport();
		CHECK( ! stream.str().empty() );

		CHECK( stream.str().find( "ODEMx Statistics Report" ) != std::string::npos );
		CHECK( stream.str().find( "Count Statistics" ) != std::string::npos );
		CHECK( stream.str().find( "Name                   | Reset at | Uses | Value |" ) != std::string::npos );
		CHECK( stream.str().find( "OStreamReportTestCount | 23       | 2    | 26    |" ) != std::string::npos );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
