//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004, 2007 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file Rate.cpp

	\author Sascha Qualitz

	 \date created at 2009/10/26

	 \brief Implementation of Rate

	\sa Rate.h

	\since 3.0
*/

#include <odemx/base/continuous/Rate.h>
#include <odemx/base/continuous/State.h>
#include <odemx/base/continuous/Continuous.h>
#include <odemx/base/continuous/Monitor.h>
#include <odemx/base/continuous/GSLContainer.h>
//#include <>

using namespace odemx::base;
using namespace odemx::base::continuous;
using namespace std;

Rate::Rate()
:	continuous(0),
	index_(0)
{}

Rate::Rate(Continuous* continuous)
:	continuous(continuous),
	index_(0)
{}

Rate::Rate(Continuous* continuous, unsigned index)
:	continuous(continuous),
	index_(index)
{}

Rate::~Rate() {
	// nothing todo!!
}

void Rate::setIndex(unsigned index) {
	index_ = index;
}

void Rate::setContinuous(Continuous* continuous) {
	this->continuous = continuous;
}

void Rate::setValue(unsigned index, double value) {
	continuous->setDerivative(index, value);
}

void Rate::setValue(unsigned index, State& value) {
	continuous->setDerivative(index, value.getValue());
}

void Rate::setValue(State& value) {
	continuous->setDerivative(index_, value.getValue());
}

void Rate::setValue(double value) {
	continuous->setDerivative(index_, value);
}

Rate& Rate::operator =(const State& value) {

	continuous->setDerivative(index_, value.getValue());

	return *this;
}

Rate& Rate::operator =(const double value) {

	//continuous->setDerivative(index_, value);
	setValue(value);
	return *this;
}

Rate& Rate::operator [](const unsigned i) {
	if(i < 0 || i > continuous->getDimension()-1)
		throw std::out_of_range("The index is out of bounds");
	//index_ = i;
	setIndex(i);

	return *this;
}
