//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004, 2007 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file DfDt.cpp

	\author Sascha Qualitz

	 \date created at 2009/10/26

	 \brief Implementation of DfDt

	\sa DfDt.h

	\since 3.0
*/

#include <odemx/base/continuous/DfDt.h>
#include <odemx/base/continuous/Continuous.h>
#include <odemx/base/continuous/Monitor.h>
#include <odemx/base/continuous/GSLContainer.h>

using namespace odemx::base;
using namespace odemx::base::continuous;
using namespace std;

DfDt::DfDt(Continuous* continuous)
:	continuous(continuous),
	index_(0)
{}

DfDt::DfDt(Continuous* continuous, unsigned index)
:	continuous(continuous),
	index_(index)
{}

DfDt::~DfDt() {
	// nothing todo!
}

double DfDt::getValue() const{
	return continuous->getDfDt(index_);
}

double DfDt::getValue(unsigned index) const{
	return continuous->getDfDt(index);
}

void DfDt::setIndex(unsigned index) {
	index_ = index;
}

void DfDt::setContinuous(Continuous* continuous) {
	this->continuous = continuous;
}

void DfDt::setValue(unsigned index, double value) {
	continuous->setDfDt(index, value);
}

void DfDt::setValue(unsigned index, DfDt& value) {
	continuous->setDfDt(index, value.getValue());
}

void DfDt::setValue(DfDt& value) {
	continuous->setDfDt(index_, value.getValue());
}

void DfDt::setValue(double value) {
	continuous->setDfDt(index_, value);
}

DfDt& DfDt::operator =(const DfDt& value) {
	if (this == &value) {
		this->continuous->setDfDt(this->index_, this->value_);
		this->isValueSet_ = false;
		return *this;
	} else {
		continuous->setDfDt(index_, value.getValue());
	}

	return *this;
}

DfDt& DfDt::operator =(const double value) {

	continuous->setDfDt(index_, value);
	isValueSet_ = false;

	return *this;
}

DfDt& DfDt::operator [](const unsigned i) {
	if(i < 0 || i > continuous->getDimension()-1)
		throw std::out_of_range("The index is out of bounds");

	index_ = i;

	if(!isValueSet_) {
		value_ = getValue(index_);
		isValueSet_ = true;
	}

	return *this;
}
