//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004, 2007 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file CellVariablesContainer.cpp

 \author Sascha Qualitz

 \date created at 2010/01/05

 \brief Implementation of class CoordinateContainer

 \sa CellVariablesContainer.h

 \since 3.0
 */

#include <odemx/base/cellular_automaton/CellVariablesContainer.h>

using namespace odemx::base;
// this include is invalid since no standard libraries are included
// because of this, the namespace std is not defined
// using namespace std;

//template <typename T>
//CellVariablesContainer<T>::CellVariablesContainer(unsigned row, unsigned column, unsigned variablesCount)
CellVariablesContainer::CellVariablesContainer(unsigned row, unsigned column, unsigned variablesCount)
:  row(row),
   column(column),
   variablesCount(variablesCount)
{
	//this->values = new T[variablesCount];
	//this->temp_values = new T[variablesCount];
	/*values = new int *[row*column];
	*values = new int [variablesCount];
	temp_values = new int *[row*column];
	*temp_values = new int [variablesCount];*/

	//input_values = new T[row*column*variablesCount];
	//state_values = new T[row*column*variablesCount];
	//output_values = new T[row*column*variablesCount];

	input_values = new int[row*column*variablesCount];
	state_values = new int[row*column*variablesCount];
	output_values = new int[row*column*variablesCount];

	//this->baseIndices = new int[variablesCount];
	//std::cout << "CellVariablesContainer::CellVariablesContainer" << std::endl;
}

//template <typename T>
//CellVariablesContainer<T>::~CellVariablesContainer() {
CellVariablesContainer::~CellVariablesContainer() {
	//nothing todo
}

/*void CellVariablesContainer::setValue(unsigned cellRow, unsigned cellColumn, unsigned variableIndex, int value) {
	this->input_values[cellRow*this->column*this->variablesCount+cellColumn*this->variablesCount+variableIndex] = value;
}*/

//template <typename T>
//void CellVariablesContainer<T>::setOutputValue(unsigned cellIndex, unsigned variableIndex, T value) {
void CellVariablesContainer::setOutputValue(unsigned cellIndex, unsigned variableIndex, int value) {
	this->output_values[cellIndex*this->variablesCount+variableIndex] = value;
}

//template <typename T>
//void CellVariablesContainer<T>::setOutputValue(unsigned cellIndex, T value) {
void CellVariablesContainer::setOutputValue(unsigned cellIndex, int value) {
	this->output_values[cellIndex] = value;
}

//template <typename T>
//T CellVariablesContainer<T>::getOutputValue(unsigned cellIndex, unsigned variableIndex) {
int CellVariablesContainer::getOutputValue(unsigned cellIndex, unsigned variableIndex) {
	return this->output_values[cellIndex*this->variablesCount+variableIndex];
}

//template <typename T>
//T CellVariablesContainer<T>::getOutputValue(unsigned cellIndex) {
int CellVariablesContainer::getOutputValue(unsigned cellIndex) {
	return this->output_values[cellIndex];
}

//template <typename T>
//void CellVariablesContainer<T>::setStateValue(unsigned cellIndex, unsigned variableIndex, T value) {
void CellVariablesContainer::setStateValue(unsigned cellIndex, unsigned variableIndex, int value) {
	this->state_values[cellIndex*this->variablesCount+variableIndex] = value;
}

//template <typename T>
//void CellVariablesContainer<T>::setStateValue(unsigned cellIndex, T value) {
void CellVariablesContainer::setStateValue(unsigned cellIndex, int value) {
	this->state_values[cellIndex] = value;
}

//template <typename T>
//T CellVariablesContainer<T>::getStateValue(unsigned cellIndex, unsigned variableIndex) {
int CellVariablesContainer::getStateValue(unsigned cellIndex, unsigned variableIndex) {
	return this->state_values[cellIndex*this->variablesCount+variableIndex];
}

//template <typename T>
//T CellVariablesContainer<T>::getStateValue(unsigned cellIndex) {
int CellVariablesContainer::getStateValue(unsigned cellIndex) {
	return this->state_values[cellIndex];
}

//template <typename T>
//void CellVariablesContainer<T>::setInputValue(unsigned cellIndex, unsigned variableIndex, T value) {
void CellVariablesContainer::setInputValue(unsigned cellIndex, unsigned variableIndex, int value) {
	this->input_values[cellIndex*this->variablesCount+variableIndex] = value;
}

//template <typename T>
//void CellVariablesContainer<T>::setInputValue(unsigned cellIndex, T value) {
void CellVariablesContainer::setInputValue(unsigned cellIndex, int value) {
	this->input_values[cellIndex] = value;
}

//template <typename T>
//T CellVariablesContainer<T>::getInputValue(unsigned cellIndex, unsigned variableIndex) {
int CellVariablesContainer::getInputValue(unsigned cellIndex, unsigned variableIndex) {
	return this->input_values[cellIndex*this->variablesCount+variableIndex];
}

//template <typename T>
//T CellVariablesContainer<T>::getInputValue(unsigned cellIndex) {
int CellVariablesContainer::getInputValue(unsigned cellIndex) {
	return this->input_values[cellIndex];
}

/*void CellVariablesContainer::setValue(unsigned cellRow, unsigned cellColumn, unsigned variableIndex, int value) {
	this->input_values[cellRow*this->column*this->variablesCount+cellColumn*this->variablesCount+variableIndex] = value;
}

void CellVariablesContainer::setValue(unsigned cellRow, unsigned cellColumn, int value) {
	this->input_values[cellRow*this->column+cellColumn] = value;
}

int CellVariablesContainer::getValue(unsigned cellRow, unsigned cellColumn, unsigned variableIndex) {
	return this->output_values[cellRow*this->column*this->variablesCount+cellColumn*this->variablesCount+variableIndex];
}

int CellVariablesContainer::getValue(unsigned cellRow, unsigned cellColumn) {
	return this->output_values[cellRow*this->column+cellColumn];
}*/

//template <typename T>
//unsigned CellVariablesContainer<T>::getNumberOfRows() {
unsigned CellVariablesContainer::getNumberOfRows() {
	return this->row;
}

//template <typename T>
//unsigned CellVariablesContainer<T>::getNumberOfColumns() {
unsigned CellVariablesContainer::getNumberOfColumns() {
	return this->column;
}

//template <typename T>
//void CellVariablesContainer<T>::initializeArrays() {
void CellVariablesContainer::initializeArrays() {
	for (int i = 0; i < row*column*variablesCount; ++i) {
		this->input_values[i] = this->state_values[i];
	}
}

//template <typename T>
//void CellVariablesContainer<T>::copyValues() {
void CellVariablesContainer::copyValues() {
	for (int i = 0; i < row*column*variablesCount; ++i) {
		this->output_values[i] = this->state_values[i];
		this->input_values[i] = this->output_values[i];
	}
}

//----------------------------------------------------------- temp function for printing values

//template <typename T>
//T* CellVariablesContainer<T>::getOutputValues() {
int* CellVariablesContainer::getOutputValues() {
	return this->state_values;
}
