//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file StateEvent.h

 \author Michael Fiedler

 \date created at 2008/11/21

 \brief Declaration of StateEvent

 \sa Monitor

 \since 3.0
 */

#ifndef ODEMX_STATEEVENT_INCLUDED
#define ODEMX_STATEEVENT_INCLUDED

#include <odemx/base/continuous/ODESolver.h>
#include <odemx/data/Producer.h>
#include <odemx/data/Observable.h>

namespace odemx {
	namespace base {
		namespace continuous {

			//forward declaration
			class StateEventObserver;

			/** \class StateEvent

				\ingroup base

				\author Michael Fiedler

				\brief check for conditions while integration and specify action

				StateEvent are for checking if continuous processes arrives an special state
				specified by condition an than triggers an Event specified by action

				\since 3.0
			 */
			class StateEvent {
			public:
				/// destruction
				virtual ~StateEvent();

				/** \name handle assigned Monitor

					@{
				 */
				/** \brief sets the Monitor where the StateEvent will be checked
					\param monitor
						pointer to the Monitor where it will be checked

					\note If this instance is already assigned to a Monitor it will automatically be transferred.
					\note If \p monitor is NULL the StateEvent will be removed from an assigned Monitor.
				 */
				void setMonitor(Monitor *monitor);

				/** \brief gets the Monitor where this StateEvent is assigned
				 */
				Monitor* getMonitor();
				//@}

				/** \brief condition which will be checked

					This is to be implemented by the user. When condition switches to true action will be triggered.

					\note If condition is true when added to the Monitor, then action immediately will be triggered.
				 */
				virtual bool condition(SimTime time) = 0;

				/** \brief action which is done when condition occurs

					This is to be implemented by the user. When condition switches to true action will be triggered.

					\note If condition is true when added to the Monitor, then action immediately will be triggered.
				 */
				virtual void action() = 0;

			private:
				/** Monitor where the StateEvent will be checked
				 */
				Monitor *monitor;

				friend class Monitor;
			};
		}
	}
}
#endif
