//------------------------------------------------------------------------------
//      Copyright (C) 2002, 2004, 2007, 2009 Humboldt-Universitaet zu Berlin
//
//      This library is free software; you can redistribute it and/or
//      modify it under the terms of the GNU Lesser General Public
//      License as published by the Free Software Foundation; either
//      version 2.1 of the License, or (at your option) any later version.
//
//      This library is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//      Lesser General Public License for more details.
//
//      You should have received a copy of the GNU Lesser General Public
//      License along with this library; if not, write to the Free Software
//      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/**
 * @file genResources.cpp
 * @author Toralf Niebuhr
 * @date created at 2011/05/01
 * @brief generator that creates .cpp and .h files from a given resource
 * @since 3.0
 */

#include <fstream>
#include <string>
#include <cctype>
#include <iostream>
// call with
// genRes <resourceName> <recourceFile> <odemxBaseFolder>

void usage () {
	std::cout << "USAGE:" << std::endl
						<< "genRes <resourceName> <recourceFile> <odemxBaseFolder>"
						<< std::endl;
}

int main(int argc, const char* argv[]) {
	if (argc < 4) {
		std::cerr << "Error: Please provide all needed parameters" << std::endl;	
		usage ();
		return -1;
	} else if (argc > 4) {
		std::cerr << "Warning: Only the first 3 arguments are used. Ignoring additional arguments." << std::endl;
	}

//----- generate full path names ------------
	std::string srcFile(argv[3]);
	srcFile += "/src/resources/";
	srcFile += argv[1];
	srcFile += ".cpp";

	std::string includeFile(argv[3]);
	includeFile += "/include/odemx/resources/";
	includeFile += argv[1];
	includeFile += ".h";

//----- open files ------------------
	std::ifstream res(argv[2]);
	std::ofstream header(includeFile.c_str() ,std::ios_base::out | std::ios_base::trunc);
	std::ofstream cpp(srcFile.c_str() ,std::ios_base::out | std::ios_base::trunc);
//----- write header file
	std::string includeGuard;
	const char * argv1 = argv[1];
	while( *argv1 )
		includeGuard += toupper(*(argv1++));
	header << "//------------------------------------------------------------------------------" << std::endl;
	header << "//      Copyright (C) 2002, 2004, 2007, 2009 Humboldt-Universitaet zu Berlin" << std::endl;
	header << "//" << std::endl;
	header << "//      This library is free software; you can redistribute it and/or" << std::endl;
	header << "//      modify it under the terms of the GNU Lesser General Public" << std::endl;
	header << "//      License as published by the Free Software Foundation; either" << std::endl;
	header << "//      version 2.1 of the License, or (at your option) any later version." << std::endl;
	header << "//" << std::endl;
	header << "//      This library is distributed in the hope that it will be useful," << std::endl;
	header << "//      but WITHOUT ANY WARRANTY; without even the implied warranty of" << std::endl;
	header << "//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU" << std::endl;
	header << "//      Lesser General Public License for more details." << std::endl;
	header << "//" << std::endl;
	header << "//      You should have received a copy of the GNU Lesser General Public" << std::endl;
	header << "//      License along with this library; if not, write to the Free Software" << std::endl;
	header << "//      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" << std::endl;
	header << "//------------------------------------------------------------------------------" << std::endl;
	header << std::endl;
	header << "/**" << std::endl;
	header << " * @file " << argv[1] << ".h" << std::endl;
	header << " * @author Toralf Niebuhr" << std::endl;
	header << " * @date generator created at 2011/05/01" << std::endl;
	header << " * @brief makes the resource "<< argv1 << " available"  << std::endl;
	header << " * @since 3.0" << std::endl;
	header << " */" << std::endl;
	
	header << "/************************************" << std::endl;
	header << " *********** DO NOT EDIT ************" << std::endl;
	header << " *** auto generated from resources **" << std::endl;
	header << " ************************************/" << std::endl;
	header << std::endl;
	header << std::endl;
	header << "#ifndef _" << includeGuard << "_HPP" << std::endl;
	header << "#define _" << includeGuard << "_HPP" << std::endl;
	header << std::endl;
	header << "namespace odemx {" << std::endl;
	header << "namespace resources {" << std::endl;
	header << std::endl;
	header << "struct " << argv[1] << " {" << std::endl;
	header << "\tstatic const char val [];"<< std::endl;
	header << "};" << std::endl;
	header << std::endl;
	header << "}} //namespace odemx::resources"<< std::endl; 
	header << "#endif" << std::endl;

//----- write src file
        cpp << "//------------------------------------------------------------------------------" << std::endl;
        cpp << "//      Copyright (C) 2002, 2004, 2007, 2009 Humboldt-Universitaet zu Berlin" << std::endl;
        cpp << "//" << std::endl;
        cpp << "//      This library is free software; you can redistribute it and/or" << std::endl;
        cpp << "//      modify it under the terms of the GNU Lesser General Public" << std::endl;
        cpp << "//      License as published by the Free Software Foundation; either" << std::endl;
        cpp << "//      version 2.1 of the License, or (at your option) any later version." << std::endl;
        cpp << "//" << std::endl;
        cpp << "//      This library is distributed in the hope that it will be useful," << std::endl;
        cpp << "//      but WITHOUT ANY WARRANTY; without even the implied warranty of" << std::endl;
        cpp << "//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU" << std::endl;
        cpp << "//      Lesser General Public License for more details." << std::endl;
        cpp << "//" << std::endl;
        cpp << "//      You should have received a copy of the GNU Lesser General Public" << std::endl;
        cpp << "//      License along with this library; if not, write to the Free Software" << std::endl;
        cpp << "//      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" << std::endl;
        cpp << "//------------------------------------------------------------------------------" << std::endl;
        cpp << std::endl;
        cpp << "/**" << std::endl;
        cpp << " * @file " << argv[1] << ".cpp" << std::endl;
        cpp << " * @author Toralf Niebuhr" << std::endl;
        cpp << " * @date generator created at 2011/05/01" << std::endl;
        cpp << " * @brief makes the resource "<< argv1 << " available"  << std::endl;
        cpp << " * @since 3.0" << std::endl;
        cpp << " */" << std::endl;

	cpp << "/************************************" << std::endl;
	cpp << " *********** DO NOT EDIT ************" << std::endl;
	cpp << " *** auto generated from resources **" << std::endl;
	cpp << " ************************************/" << std::endl;
	cpp << std::endl;
	cpp << std::endl;
	cpp << "#include <odemx/resources/" << argv[1] << ".h" << ">" << std::endl;
	cpp << std::endl;
	cpp << "const char odemx::resources::" << argv[1] << "::val[] = {" << std::endl;
	int num = 0;
	while(res.good()) {
		if(num++ >= 10) {
			num = 0;
			cpp << std::endl;
		}
		int get = res.get();
		if (res.good()) {
			cpp << "0x" << std::hex << get << std::dec << ", ";
		}
	}
	cpp << "};" << std::endl;

}

