//
// NodeIteratorTest.cpp
//
// $Id: //poco/svn/XML/testsuite/src/NodeIteratorTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "NodeIteratorTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/DOM/NodeIterator.h"
#include "Poco/DOM/NodeFilter.h"
#include "Poco/DOM/Document.h"
#include "Poco/DOM/Element.h"
#include "Poco/DOM/Text.h"
#include "Poco/DOM/AutoPtr.h"


using Poco::XML::NodeIterator;
using Poco::XML::NodeFilter;
using Poco::XML::Element;
using Poco::XML::Document;
using Poco::XML::Text;
using Poco::XML::Node;
using Poco::XML::AutoPtr;
using Poco::XML::XMLString;


namespace
{
	class TestNodeFilter: public NodeFilter
	{
		short acceptNode(Node* node)
		{
			if (node->innerText() == "text1")
				return NodeFilter::FILTER_ACCEPT;
			else
				return NodeFilter::FILTER_REJECT;
		}
	};
}


NodeIteratorTest::NodeIteratorTest(const std::string& name): CppUnit::TestCase(name)
{
}


NodeIteratorTest::~NodeIteratorTest()
{
}


void NodeIteratorTest::testShowAll()
{
	AutoPtr<Document> pDoc = new Document;
	AutoPtr<Element> pRoot = pDoc->createElement("root");
	AutoPtr<Element> pElem1 = pDoc->createElement("elem");
	AutoPtr<Element> pElem2 = pDoc->createElement("elem");
	AutoPtr<Text> pText1 = pDoc->createTextNode("text1");
	AutoPtr<Text> pText2 = pDoc->createTextNode("text2");
	
	pElem1->appendChild(pText1);
	pElem2->appendChild(pText2);
	pRoot->appendChild(pElem1);
	pRoot->appendChild(pElem2);
	pDoc->appendChild(pRoot);
	
	NodeIterator it(pRoot, NodeFilter::SHOW_ALL);
	
	assert (it.nextNode() == pRoot);
	assert (it.nextNode() == pElem1);
	assert (it.nextNode() == pText1);
	assert (it.nextNode() == pElem2);
	assert (it.nextNode() == pText2);
	assert (it.nextNode() == 0);
	
	assert (it.previousNode() == pText2);
	assert (it.previousNode() == pElem2);
	assert (it.previousNode() == pText1);
	assert (it.previousNode() == pElem1);
	assert (it.previousNode() == pRoot);
	assert (it.previousNode() == 0);
}


void NodeIteratorTest::testShowElements()
{
	AutoPtr<Document> pDoc = new Document;
	AutoPtr<Element> pRoot = pDoc->createElement("root");
	AutoPtr<Element> pElem1 = pDoc->createElement("elem");
	AutoPtr<Element> pElem2 = pDoc->createElement("elem");
	AutoPtr<Text> pText1 = pDoc->createTextNode("text1");
	AutoPtr<Text> pText2 = pDoc->createTextNode("text2");
	
	pElem1->appendChild(pText1);
	pElem2->appendChild(pText2);
	pRoot->appendChild(pElem1);
	pRoot->appendChild(pElem2);
	pDoc->appendChild(pRoot);
	
	NodeIterator it(pRoot, NodeFilter::SHOW_ELEMENT);
	
	assert (it.nextNode() == pRoot);
	assert (it.nextNode() == pElem1);
	assert (it.nextNode() == pElem2);
	assert (it.nextNode() == 0);
	
	assert (it.previousNode() == pElem2);
	assert (it.previousNode() == pElem1);
	assert (it.previousNode() == pRoot);
	assert (it.previousNode() == 0);
}


void NodeIteratorTest::testFilter()
{
	AutoPtr<Document> pDoc = new Document;
	AutoPtr<Element> pRoot = pDoc->createElement("root");
	AutoPtr<Element> pElem1 = pDoc->createElement("elem");
	AutoPtr<Element> pElem2 = pDoc->createElement("elem");
	AutoPtr<Text> pText1 = pDoc->createTextNode("text1");
	AutoPtr<Text> pText2 = pDoc->createTextNode("text2");
	
	pElem1->appendChild(pText1);
	pElem2->appendChild(pText2);
	pRoot->appendChild(pElem1);
	pRoot->appendChild(pElem2);
	pDoc->appendChild(pRoot);
	
	TestNodeFilter filter;
	NodeIterator it(pRoot, NodeFilter::SHOW_ELEMENT, &filter);
	
	assert (it.nextNode() == pElem1);
	assert (it.nextNode() == 0);
	
	assert (it.previousNode() == pElem1);
	assert (it.previousNode() == 0);
}


void NodeIteratorTest::testShowNothing()
{
	AutoPtr<Document> pDoc = new Document;
	AutoPtr<Element> pRoot = pDoc->createElement("root");
	AutoPtr<Element> pElem1 = pDoc->createElement("elem");
	AutoPtr<Element> pElem2 = pDoc->createElement("elem");
	AutoPtr<Text> pText1 = pDoc->createTextNode("text1");
	AutoPtr<Text> pText2 = pDoc->createTextNode("text2");
	
	pElem1->appendChild(pText1);
	pElem2->appendChild(pText2);
	pRoot->appendChild(pElem1);
	pRoot->appendChild(pElem2);
	pDoc->appendChild(pRoot);
	
	NodeIterator it(pRoot, 0);
	
	assert (it.nextNode() == 0);
	
	assert (it.previousNode() == 0);
}


void NodeIteratorTest::setUp()
{
}


void NodeIteratorTest::tearDown()
{
}


CppUnit::Test* NodeIteratorTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("NodeIteratorTest");

	CppUnit_addTest(pSuite, NodeIteratorTest, testShowAll);
	CppUnit_addTest(pSuite, NodeIteratorTest, testShowElements);
	CppUnit_addTest(pSuite, NodeIteratorTest, testFilter);
	CppUnit_addTest(pSuite, NodeIteratorTest, testShowNothing);

	return pSuite;
}
