//
// NamePoolTest.cpp
//
// $Id: //poco/svn/XML/testsuite/src/NamePoolTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "NamePoolTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/XML/NamePool.h"
#include "Poco/XML/Name.h"
#include "Poco/DOM/AutoPtr.h"


using Poco::XML::NamePool;
using Poco::XML::Name;
using Poco::XML::AutoPtr;


NamePoolTest::NamePoolTest(const std::string& name): CppUnit::TestCase(name)
{
}


NamePoolTest::~NamePoolTest()
{
}


void NamePoolTest::testNamePool()
{
	AutoPtr<NamePool> pool = new NamePool;
	const Name* pName = 0;
	Name name("pre:local", "http://www.appinf.com");
	
	pName = &pool->insert(name);
	const Name* pName2 = &pool->insert("pre:local", "http://www.appinf.com", "local");
	assert (pName == pName2);
	
	pName2 = &pool->insert("pre:local2", "http://www.appinf.com", "local2");
	assert (pName2 != pName);
	
	pName2 = &pool->insert(name);
	assert (pName2 == pName);
	
	pName2 = &pool->insert(*pName);
	assert (pName2 == pName);
}


void NamePoolTest::setUp()
{
}


void NamePoolTest::tearDown()
{
}


CppUnit::Test* NamePoolTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("NamePoolTest");

	CppUnit_addTest(pSuite, NamePoolTest, testNamePool);

	return pSuite;
}
