//
// NodeAppender.cpp
//
// $Id: //poco/svn/XML/src/NodeAppender.cpp#2 $
//
// Library: XML
// Package: DOM
// Module:  NodeAppender
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/DOM/NodeAppender.h"
#include "Poco/DOM/Element.h"
#include "Poco/DOM/DOMException.h"


namespace Poco {
namespace XML {


NodeAppender::NodeAppender(Element* parent):
	_pParent(parent),
	_pLast(0)
{
	poco_check_ptr (parent);

	_pLast = static_cast<AbstractNode*>(_pParent->lastChild());
}


NodeAppender::~NodeAppender()
{
}


void NodeAppender::appendChild(Node* newChild)
{
	poco_check_ptr (newChild);
	poco_assert (_pLast == 0 || _pLast->_pNext == 0);

	if (static_cast<AbstractNode*>(newChild)->_pOwner != _pParent->_pOwner)
		throw DOMException(DOMException::WRONG_DOCUMENT_ERR);
		
	if (newChild->nodeType() == Node::DOCUMENT_FRAGMENT_NODE)
	{
		AbstractContainerNode* pFrag = static_cast<AbstractContainerNode*>(newChild);
		AbstractNode* pChild = pFrag->_pFirstChild;
		if (pChild)
		{
			if (_pLast)
				_pLast->_pNext = pChild;
			else
				_pParent->_pFirstChild = pChild;
			while (pChild)
			{
				_pLast = pChild;
				pChild->_pParent = _pParent;
				pChild = pChild->_pNext;
			}
			pFrag->_pFirstChild = 0;
		}
	}
	else
	{
		AbstractNode* pAN = static_cast<AbstractNode*>(newChild);
		pAN->duplicate();
		if (pAN->_pParent) 
			pAN->_pParent->removeChild(pAN);
		pAN->_pParent = _pParent;
		if (_pLast)
			_pLast->_pNext = pAN;
		else
			_pParent->_pFirstChild = pAN;
		_pLast = pAN;
	}
}


} } // namespace Poco::XML
