//
// TextField.cpp
//
// $Id: //poco/Main/WebWidgets/src/TextField.cpp#9 $
//
// Library: WebWidgets
// Package: Controls
// Module:  TextField
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/TextField.h"
#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/Delegate.h"


namespace Poco {
namespace WebWidgets {


TextField::TextField(const std::string& name, const std::type_info& type, Cell::Ptr ptrCell):
	Control(name, type)
{
	init(ptrCell);
}


TextField::TextField(const std::type_info& type, Cell::Ptr ptrCell):
	Control(type)
{
	init(ptrCell);
}


TextField::TextField(const std::string& name, const std::type_info& type):
	Control(name, type)
{
	init();
}


TextField::TextField(const std::type_info& type):
	Control(type)
{
	init();
}



TextField::TextField(const std::string& name, const std::string& txt):
	Control(name, typeid(TextField))
{
	init();
	setString(txt);
}


TextField::TextField(const std::string& name):
	Control(name, typeid(TextField))
{
	init();
}


TextField::TextField():
	Control(typeid(TextField))
{
	init();
}


TextField::~TextField()
{
}


void TextField::setPlaceHolder(const std::string& text)
{
	cell<TextFieldCell>()->setPlaceHolder(text);
}


const std::string& TextField::getPlaceHolder() const
{
	return cell<TextFieldCell>()->getPlaceHolder();
}


void TextField::setMaxLength(int length)
{
	cell<TextFieldCell>()->setMaxLength(length);
}


int TextField::getMaxLength() const
{
	return cell<TextFieldCell>()->getMaxLength();
}


void TextField::init()
{
	TextFieldCell* pCell = new TextFieldCell(this);
	pCell->textChanged += Poco::delegate(this, &TextField::fireTextChanged);
	setCell(pCell);
}



void TextField::init(Cell::Ptr ptrCell)
{
	TextFieldCell::Ptr ptr = ptrCell.cast<TextFieldCell>();
	poco_check_ptr (ptr);

	ptr->textChanged += Poco::delegate(this, &TextField::fireTextChanged);
	setCell(ptrCell);
}


void TextField::fireTextChanged(ValueChange& vc)
{
	textChanged(this, vc);
}


const std::string& TextField::getContent() const
{
	return RefAnyCast<std::string>(this->getCell()->getValue());
}


} } // namespace Poco::WebWidgets
