//
// TableColumn.cpp
//
// $Id: //poco/Main/WebWidgets/src/TableColumn.cpp#7 $
//
// Library: WebWidgets
// Package: Views
// Module:  TableColumn
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/TableColumn.h"


namespace Poco {
namespace WebWidgets {


TableColumn::TableColumn(Cell::Ptr pCellFormat):
	View(typeid(TableColumn)),
	_pCell(pCellFormat),
	_sortable(false),
	_hidden(false),
	_resizable(true),
	_header()
{
	if (_pCell)
		_pCell->setOwner(this);
}


TableColumn::TableColumn(Cell::Ptr pCellFormat, const std::string& name, int width, bool sortable):
	View(typeid(TableColumn)),
	_pCell(pCellFormat),
	_sortable(sortable),
	_hidden(false),
	_resizable(true),
	_header(name)
{
	setWidth(width);
	if (_pCell)
		_pCell->setOwner(this);
}


TableColumn::~TableColumn()
{
}


} } // namespace Poco::WebWidgets
