//
// Delegate.cpp
//
// $Id: //poco/Main/WebWidgets/src/Delegate.cpp#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  Delegate
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Delegate.h"
#include <algorithm>


namespace Poco {
namespace WebWidgets {


//
// Delegate
//


Delegate::Delegate():
	_pImpl(0)
{
}

	
Delegate::Delegate(const Delegate& delegate):
	_pImpl(delegate._pImpl)
{
	if (_pImpl) 
		_pImpl->duplicate();
}

	
Delegate::Delegate(BasicDelegateImpl* pImpl):
	_pImpl(pImpl)
{
}

			
Delegate::~Delegate()
{
	if (_pImpl) 
		_pImpl->release();
}

	
void Delegate::swap(Delegate& delegate)
{
	std::swap(_pImpl, delegate._pImpl);
}

	
Delegate& Delegate::operator = (const Delegate& delegate)
{
	Delegate tmp(delegate);
	swap(tmp);
	return *this;
}

	
void Delegate::operator () (void* pSender) const
{
	if (_pImpl) 
		_pImpl->invoke(pSender);
}


Delegate::operator void* () const
{
	return _pImpl;
}


bool Delegate::operator ! () const
{
	return _pImpl == 0;
}


//
// BasicDelegateImpl
//


BasicDelegateImpl::BasicDelegateImpl()
{
}


BasicDelegateImpl::~BasicDelegateImpl()
{
}


} } // namespace Poco::WebWidgets
