//
// DateField.cpp
//
// $Id: //poco/Main/WebWidgets/src/DateField.cpp#3 $
//
// Library: WebWidgets
// Package: Controls
// Module:  DateField
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/DateField.h"
#include "Poco/WebWidgets/DateFieldCell.h"


namespace Poco {
namespace WebWidgets {


DateField::DateField(const std::string& name, const std::type_info& type):
	TextField(name, type, new DateFieldCell(this))
{
}


DateField::DateField(const std::type_info& type):
	TextField(type, new DateFieldCell(this))
{
}


DateField::DateField(const std::string& name):
	TextField(name, typeid(DateField), new DateFieldCell(this))
{
}


DateField::DateField():
	TextField(typeid(DateField), new DateFieldCell(this))
{
}


DateField::~DateField()
{
}


void DateField::setFormat(const std::string& dateFormat)
{
	cell<DateFieldCell>()->setFormat(dateFormat);
}


const std::string& DateField::getFormat() const
{
	return cell<DateFieldCell>()->getFormat();
}

void DateField::setDate(const Poco::DateTime& dt)
{
	cell<DateFieldCell>()->setDate(dt);
}


const Poco::DateTime& DateField::getDate() const
{
	return cell<DateFieldCell>()->getDate();
}


} } // namespace Poco::WebWidgets
