//
// Control.cpp
//
// $Id: //poco/Main/WebWidgets/src/Control.cpp#3 $
//
// Library: WebWidgets
// Package: Controls
// Module:  Control
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Control.h"


namespace Poco {
namespace WebWidgets {


Control::Control(const std::string& name, const std::type_info& type):
	View(name, type)
{
}

	
Control::Control(const std::type_info& type):
	View(type)
{
}

	
Control::~Control()
{
}


void Control::enable(bool enabled)
{
	_pCell->enable(enabled);
}


void Control::disable()
{
	_pCell->disable();
}


bool Control::isEnabled() const
{
	return _pCell->isEnabled();
}


void Control::setEditable(bool editable)
{
	_pCell->setEditable(editable);
}


bool Control::isEditable() const
{
	return _pCell->isEditable();
}


void Control::setText(const std::string& text)
{
	_pCell->setString(text);
}


std::string Control::getText() const
{
	return _pCell->getString();
}


void Control::setToolTip(const std::string& text)
{
	_pCell->setToolTip(text);
}


std::string Control::getToolTip() const
{
	return _pCell->getToolTip();
}


void Control::renderHead(const RenderContext& context, std::ostream& str) const
{
	//also render invisible stuff if (isVisible())
	{
		_pCell->renderHead(context, str);
	}
}


void Control::renderBody(const RenderContext& context, std::ostream& str) const
{
	//also render invisible stuff if (isVisible())
	{
		_pCell->renderBody(context, str);
	}
}


} } // namespace Poco::WebWidgets
