//
// Cell.cpp
//
// $Id: //poco/Main/WebWidgets/src/Cell.cpp#5 $
//
// Library: WebWidgets
// Package: Core
// Module:  Cell
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Cell.h"
#include "Poco/WebWidgets/StringFormatter.h"
#include "Poco/Net//HTTPServerResponse.h"


namespace Poco {
namespace WebWidgets {


Cell::Cell(View* pOwner, const std::type_info& type):
	Renderable(type),
	_em(EM_SELECTCONTENT),
	_pOwner(pOwner),
	_enabled(true),
	_editable(true),
	_toolTip(),
	_value(),
	_pFormatter(new StringFormatter()),
	_rowIndex(-1)
{
}


Cell::Cell(const std::type_info& type):
	Renderable(type),
	_em(EM_SELECTCONTENT),
	_pOwner(0),
	_enabled(true),
	_editable(true),
	_toolTip(),
	_value(),
	_pFormatter(new StringFormatter()),
	_rowIndex(-1)
{
}


Cell::~Cell()
{
}


void Cell::enable(bool enabled)
{
	_enabled = enabled;
}


void Cell::setToolTip(const std::string& toolTip)
{
	_toolTip = toolTip;
}


void Cell::setValue(const Poco::Any& value)
{
	_value = value;
}


void Cell::setValue(const std::string& value)
{
	if (_pFormatter)
		_value = _pFormatter->parse(value);
	else
		_value = value;
}


void Cell::setFormatter(Formatter::Ptr pFormatter)
{
	_pFormatter = pFormatter;
}


void Cell::setString(const std::string& value)
{
	_value = value;
}

	
std::string Cell::getString() const
{
	if (_pFormatter)
		return _pFormatter->format(_value);
	else
		return Poco::AnyCast<std::string>(_value);
}


void Cell::setInt(int value)
{
	_value = value;
}

	
int Cell::getInt() const
{
	return Poco::AnyCast<int>(_value);
}


void Cell::setDouble(double value)
{
	_value = value;
}

	
double Cell::getDouble() const
{
	return Poco::AnyCast<double>(_value);
}


void Cell::setBool(bool value)
{
	_value = value;
}

	
bool Cell::getBool() const
{
	return Poco::AnyCast<bool>(_value);
}


void Cell::setOwner(View* pOwner)
{
	_pOwner = pOwner;
}


void Cell::setRowIndex(int rowIndex)
{
	_rowIndex = rowIndex;
}


void Cell::handleForm(const std::string& field, const std::string& value)
{
}


void Cell::handleAjaxRequest(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response)
{
	response.send();
}


} } // namespace Poco::WebWidgets
