//
// AjaxDelegate.cpp
//
// $Id: //poco/Main/WebWidgets/src/AjaxDelegate.cpp#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  AjaxDelegate
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/AjaxDelegate.h"
#include "Poco/Net/NameValueCollection.h"
#include "Poco/Net/HTTPServerResponse.h"
#include <algorithm>


namespace Poco {
namespace WebWidgets {


AjaxParameters::AjaxParameters(const Poco::Net::NameValueCollection& a, Poco::Net::HTTPServerResponse& r):
	args(a),
	response(r),
	handled(false)
{
}


//
// AjaxDelegate
//


AjaxDelegate::AjaxDelegate():
	_pImpl(0)
{
}

	
AjaxDelegate::AjaxDelegate(const AjaxDelegate& delegate):
	_pImpl(delegate._pImpl)
{
	if (_pImpl) 
		_pImpl->duplicate();
}

	
AjaxDelegate::AjaxDelegate(BasicAjaxDelegateImpl* pImpl):
	_pImpl(pImpl)
{
}

			
AjaxDelegate::~AjaxDelegate()
{
	if (_pImpl) 
		_pImpl->release();
}

	
void AjaxDelegate::swap(AjaxDelegate& delegate)
{
	std::swap(_pImpl, delegate._pImpl);
}

	
AjaxDelegate& AjaxDelegate::operator = (const AjaxDelegate& delegate)
{
	AjaxDelegate tmp(delegate);
	swap(tmp);
	return *this;
}

	
void AjaxDelegate::operator () (void* pSender, const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response, bool& handled) const
{
	if (_pImpl) 
	{
		AjaxParameters params(args, response);
		_pImpl->invoke(pSender, params);
		handled = params.handled;
	}
}


AjaxDelegate::operator void* () const
{
	return _pImpl;
}


bool AjaxDelegate::operator ! () const
{
	return _pImpl == 0;
}


//
// BasicAjaxDelegateImpl
//


BasicAjaxDelegateImpl::BasicAjaxDelegateImpl()
{
}


BasicAjaxDelegateImpl::~BasicAjaxDelegateImpl()
{
}


} } // namespace Poco::WebWidgets
