//
// TextField.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/TextField.h#10 $
//
// Library: WebWidgets
// Package: Controls
// Module:  TextField
//
// Definition of the TextField class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_TextField_INCLUDED
#define WebWidgets_TextField_INCLUDED


#include "Poco/WebWidgets/Control.h"
#include "Poco/WebWidgets/Event.h"
#include "Poco/WebWidgets/JavaScriptEvent.h"
#include "Poco/WebWidgets/TextFieldCell.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API TextField: public Control
	/// A TextField.
{
public:
	typedef Poco::AutoPtr<TextField> Ptr;
	
	typedef TextFieldCell::ValueChange ValueChange;
	
	JavaScriptEvent<TextFieldCell::ValueChange> textChanged;

	TextField(const std::string& name, const std::string& text);
		/// Creates a TextField with the given name and content.
		
	TextField(const std::string& name);
		/// Creates a TextField with the given name.

	TextField();
		/// Creates an anonymous TextField.

	void setPlaceHolder(const std::string& text);
		/// Sets the placeholder text for the text field.

	const std::string& getPlaceHolder() const;
		/// Returns the placeholder text for the text field.

	void setMaxLength(int length);
		/// Sets the maximum length of the field.
		/// Specify -1 for unlimited.

	int getMaxLength() const;
		/// Returns the maximum length of the text field, or -1
		/// if the length is unlimited.

	void fireTextChanged(TextFieldCell::ValueChange& vc);
		/// Fires the textChanged event.
		
	const std::string& getContent() const;
		/// returns the text content of the TextField. Same value as returned by getText(),getString()

	void setContent(const std::string& txt);
		/// Sets the content
		
protected:
	TextField(const std::string& name, const std::type_info& type);
		/// Creates a TextField and assigns it the given name.

	TextField(const std::type_info& type);
		/// Creates a TextField.

	TextField(const std::string& name, const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a TextField and assigns it the given name.

	TextField(const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a TextField.

	~TextField();
		/// Destroys the TextField.

	void init();
		/// Common init code for all ctors.

	void init(Cell::Ptr pCell);
		/// Common init code for all ctors.
};


inline void TextField::setContent(const std::string& txt)
{
	setString(txt);
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_TextField_INCLUDED
