//
// TextEdit.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/TextEdit.h#3 $
//
// Library: WebWidgets
// Package: Controls
// Module:  TextEdit
//
// Definition of the TextEdit class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_TextEdit_INCLUDED
#define WebWidgets_TextEdit_INCLUDED


#include "Poco/WebWidgets/Control.h"
#include "Poco/WebWidgets/Event.h"
#include "Poco/WebWidgets/JavaScriptEvent.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API TextEdit: public Control
	/// TextEdit is a multi-line textfield
{
public:
	typedef Poco::AutoPtr<TextEdit> Ptr;
	typedef Event<TextEdit> TextEditEvent;

	JavaScriptEvent<TextEditEvent> textChanged;

	TextEdit(const std::string& name);
		/// Creates a TextField with the given name.

	TextEdit();
		/// Creates an anonymous TextField.

	void setPlaceHolder(const std::string& text);
		/// Sets the placeholder text for the text field.

	const std::string& getPlaceHolder() const;
		/// Returns the placeholder text for the text field.

	void setHeightInPixel(int height);
		/// Sets the height in pixel. A negative value equals autoSize.

	int getHeightInPixel() const;
		/// Returns the height in pixel. A negative value equals autoSize.

	void setGrow(bool grow);
		/// Specifies if the control can grow with its content.
		
	bool getGrow() const;
		/// Returns if the control can grow with its content.

	void fireTextChanged(void* pSender);
		/// Fires the textChanged event.
protected:
	TextEdit(const std::string& name, const std::type_info& type);
		/// Creates a TextEdit and assigns it the given name.

	TextEdit(const std::type_info& type);
		/// Creates a TextEdit.

	TextEdit(const std::string& name, const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a TextEdit and assigns it the given name.

	TextEdit(const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a TextEdit.

	~TextEdit();
		/// Destroys the TextEdit.

	void init();
		/// Common init code for all ctors.

	void init(Cell::Ptr pCell);
		/// Common init code for all ctors.
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_TextEdit_INCLUDED
