//
// TableColumn.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/TableColumn.h#7 $
//
// Library: WebWidgets
// Package: Views
// Module:  TableColumn
//
// Definition of the TableColumn class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_TableColumn_INCLUDED
#define WebWidgets_TableColumn_INCLUDED


#include "Poco/WebWidgets/View.h"
#include "Poco/WebWidgets/Cell.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API TableColumn: public View
	/// TableColumn desribes a column
{
public:
	typedef Poco::AutoPtr<TableColumn> Ptr;

	TableColumn(Cell::Ptr pCellFormat);
		/// Creates an unnamed TableColumn with unspecified width, allowEdit and sortable are false

	TableColumn(Cell::Ptr pCellFormat, const std::string& headerText, int width = -1, bool sortable = false);
		/// Creates an initialized TableColumn

	bool isSortable() const;
		/// Returns if the column is sortable

	void setSortable(bool val);
		/// Sets if the column is sortable

	Cell::Ptr getCell() const;
		/// Returns the cell

	void setText(const std::string& text);
		/// Sets the header of the column

	void setHeader(const std::string& text);
		/// Sets the header of the column

	std::string getText() const;
		/// Returns the header of the column

	const std::string& getHeader() const;
		/// Returns the header of the column
		
	void setEditable(bool editable = true);
		/// Sets whether the Cell's contents can be edited.

	bool isEditable() const;
		/// Returns true iff the Cell is editable.
		
	void setEditMode(Cell::EditMode em);
		/// Sets the edit mode of the cell
		
	Cell::EditMode getEditMode() const;
		/// Returns the edit mode of the cell
		
	void setCustomRenderer(const std::string& jsCode);
		/// Allows to set custom JavaScript code that renders the values of the columns
		/// This code depends on the rendering library used during run-time!

	const std::string& getCustomRenderer() const;
		/// Returns the custom JavaScript code used to render the values of this column.
		/// Empty string if none set
		
	void setHidden(bool hide);
		/// Hides/Shows a tablecolumn
		
	bool isHidden() const;
		/// Returns the hidden status of the TableColumn

	void resizable(bool val);
		/// Sets if th ecolumn is resizable

	bool resizable() const;
		/// Returns if the column is resizable

protected:
	virtual ~TableColumn();
		/// Destroys the TableColumn.

private:
	Cell::Ptr   _pCell;
	bool        _sortable;
	bool        _hidden;
	bool        _resizable;
	std::string _header;
	std::string _customRenderer;
};


//
// Inlines
//

inline Cell::Ptr TableColumn::getCell() const
{
	return _pCell;
}


inline bool TableColumn::isSortable() const
{
	return _sortable;
}


inline void TableColumn::setSortable(bool val)
{
	_sortable = val;
}


inline void TableColumn::setText(const std::string& text)
{
	setHeader(text);
}


inline std::string TableColumn::getText() const
{
	return getHeader();
}


inline void TableColumn::setHeader(const std::string& text)
{
	_header = text;
}


inline const std::string& TableColumn::getHeader() const
{
	return _header;
}


inline void TableColumn::setEditable(bool editable)
{
	_pCell->setEditable(editable);
}


inline bool TableColumn::isEditable() const
{
	return _pCell->isEditable();
}


inline void TableColumn::setEditMode(Cell::EditMode em)
{
	_pCell->setEditMode(em);
}

		
inline Cell::EditMode TableColumn::getEditMode() const

{
	return _pCell->getEditMode();
}
	

inline void TableColumn::setCustomRenderer(const std::string& jsCode)
{
	_customRenderer = jsCode;
}


inline const std::string& TableColumn::getCustomRenderer() const
{
	return _customRenderer;
}


inline void TableColumn::setHidden(bool hide)
{
	_hidden = hide;
}

		
inline bool TableColumn::isHidden() const
{
	return _hidden;
}


inline void TableColumn::resizable(bool val)
{
	_resizable = val;
}


inline bool TableColumn::resizable() const
{
	return _resizable;
}

	
} } // namespace Poco::WebWidgets


#endif // WebWidgets_TableColumn_INCLUDED
