//
// PeriodicUpdater.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/PeriodicUpdater.h#4 $
//
// Library: WebWidgets
// Package: Views
// Module:  PeriodicUpdater
//
// Definition of the PeriodicUpdater class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_PeriodicUpdater_INCLUDED
#define WebWidgets_PeriodicUpdater_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/WebWidgets/TableUpdater.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include "Poco/Timer.h"


namespace Poco {
namespace WebWidgets {
	class Table;


class WebWidgets_API PeriodicUpdater: public TableUpdater
	/// PeriodicUpdater periodically calls update on its inner child
{
public:
	typedef Poco::AutoPtr<PeriodicUpdater> Ptr;

	PeriodicUpdater(TableUpdater::Ptr pUpdater, Poco::UInt32 interValInSeconds);
		/// Creates the PeriodicUpdater for the given table
		/// You must call start manually to start it!

	void update();
		/// Updates the table from a given source

	TableModel::Ptr model();

	const TableModel::Ptr model() const;

	void start();
		/// Starts auto updating

	void stop();
		/// Stops auto updating
		
	Poco::UInt32 intervalInSeconds() const;
		/// Returns the interval in seconds

protected:
	virtual ~PeriodicUpdater();
		/// Destroys the PeriodicUpdater.

	void updateTimer(Poco::Timer& timer);

private:
	TableUpdater::Ptr _pUpdater;
	Poco::UInt32      _interValInSeconds;
	Poco::Timer       _timer;
};


//
// Inlines
//


inline void PeriodicUpdater::update()
{
	return _pUpdater->update();
}


inline TableModel::Ptr PeriodicUpdater::model()
{
	return _pUpdater->model();
}


inline const TableModel::Ptr PeriodicUpdater::model() const
{
	return _pUpdater->model();
}


inline void PeriodicUpdater::start()
{
	TimerCallback<PeriodicUpdater> callback(*this, &PeriodicUpdater::updateTimer);
	_timer.start(callback);
}


inline void PeriodicUpdater::stop()
{
	_timer.stop();
}


inline void PeriodicUpdater::updateTimer(Poco::Timer&)
{
	update();
}


inline Poco::UInt32 PeriodicUpdater::intervalInSeconds() const
{
	return _interValInSeconds;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_PeriodicUpdater_INCLUDED
