//
// NumberFieldCell.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/NumberFieldCell.h#2 $
//
// Library: WebWidgets
// Package: Controls
// Module:  NumberFieldCell
//
// Definition of the NumberFieldCell class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_NumberFieldCell_INCLUDED
#define WebWidgets_NumberFieldCell_INCLUDED


#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/WebWidgets/IntFormatter.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API NumberFieldCell: public TextFieldCell
	/// A cell for a NumberField
{
public:
	typedef Poco::AutoPtr<NumberFieldCell> Ptr;

	NumberFieldCell(View* pOwner, Formatter::Ptr pF = new IntFormatter());
		/// Creates the NumberFieldCell.

	virtual ~NumberFieldCell();
		/// Destroys the NumberFieldCell.
		
	bool serializeJSON(std::ostream& out, const std::string& name);	
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_NumberFieldCell_INCLUDED
