//
// LookAndFeel.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/LookAndFeel.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  LookAndFeel
//
// Definition of the LookAndFeel class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_LookAndFeel_INCLUDED
#define WebWidgets_LookAndFeel_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/WebWidgets/Renderer.h"
#include "Poco/WebWidgets/Type.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include <map>
#include <typeinfo>


namespace Poco {
namespace WebWidgets {


class WebWidgets_API LookAndFeel: public Poco::RefCountedObject
	/// LookAndFeel is basically a factory for Renderer
	/// objects. It is used by Renderable objects to obtain
	/// their Renderer object.
{
public:
	typedef Poco::AutoPtr<LookAndFeel> Ptr;

	LookAndFeel();
		/// Creates the LookAndFeel object.
		
	Renderer::Ptr rendererFor(const std::type_info& type) const;
		/// Returns the renderer object for the given type.
		///
		/// Throws a Poco::NotFoundException if the renderer for the given
		/// class does not exist.
		
	void registerRenderer(const std::type_info& type, Renderer::Ptr pRenderer);
		/// Registers a renderer for the given type.

protected:		
	~LookAndFeel();
		/// Destroys the LookAndFeel object.

private:
	LookAndFeel(const LookAndFeel&);
	LookAndFeel& operator = (const LookAndFeel&);

	typedef std::map<Type, Renderer::Ptr> RendererMap;
	
	RendererMap _rendererMap;
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_LookAndFeel_INCLUDED
